// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutGeofenceRequest private constructor(builder: Builder) {
    /**
     * The geofence collection to store the geofence in.
     */
    public val collectionName: kotlin.String = requireNotNull(builder.collectionName) { "A non-null value must be provided for collectionName" }
    /**
     * An identifier for the geofence. For example, `ExampleGeofence-1`.
     */
    public val geofenceId: kotlin.String = requireNotNull(builder.geofenceId) { "A non-null value must be provided for geofenceId" }
    /**
     * Associates one of more properties with the geofence. A property is a key-value pair stored with the geofence and added to any geofence event triggered with that geofence.
     *
     * Format: `"key" : "value"`
     */
    public val geofenceProperties: Map<String, String>? = builder.geofenceProperties
    /**
     * Contains the details to specify the position of the geofence. Can be a polygon, a circle or a polygon encoded in Geobuf format. Including multiple selections will return a validation error.
     *
     * The [ geofence polygon](https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html) format supports a maximum of 1,000 vertices. The [Geofence Geobuf](https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html) format supports a maximum of 100,000 vertices.
     */
    public val geometry: aws.sdk.kotlin.services.location.model.GeofenceGeometry? = builder.geometry

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.PutGeofenceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutGeofenceRequest(")
        append("collectionName=$collectionName,")
        append("geofenceId=$geofenceId,")
        append("geofenceProperties=*** Sensitive Data Redacted ***,")
        append("geometry=$geometry")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionName.hashCode()
        result = 31 * result + (geofenceId.hashCode())
        result = 31 * result + (geofenceProperties?.hashCode() ?: 0)
        result = 31 * result + (geometry?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutGeofenceRequest

        if (collectionName != other.collectionName) return false
        if (geofenceId != other.geofenceId) return false
        if (geofenceProperties != other.geofenceProperties) return false
        if (geometry != other.geometry) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.PutGeofenceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The geofence collection to store the geofence in.
         */
        public var collectionName: kotlin.String? = null
        /**
         * An identifier for the geofence. For example, `ExampleGeofence-1`.
         */
        public var geofenceId: kotlin.String? = null
        /**
         * Associates one of more properties with the geofence. A property is a key-value pair stored with the geofence and added to any geofence event triggered with that geofence.
         *
         * Format: `"key" : "value"`
         */
        public var geofenceProperties: Map<String, String>? = null
        /**
         * Contains the details to specify the position of the geofence. Can be a polygon, a circle or a polygon encoded in Geobuf format. Including multiple selections will return a validation error.
         *
         * The [ geofence polygon](https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html) format supports a maximum of 1,000 vertices. The [Geofence Geobuf](https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html) format supports a maximum of 100,000 vertices.
         */
        public var geometry: aws.sdk.kotlin.services.location.model.GeofenceGeometry? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.PutGeofenceRequest) : this() {
            this.collectionName = x.collectionName
            this.geofenceId = x.geofenceId
            this.geofenceProperties = x.geofenceProperties
            this.geometry = x.geometry
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.PutGeofenceRequest = PutGeofenceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.GeofenceGeometry] inside the given [block]
         */
        public fun geometry(block: aws.sdk.kotlin.services.location.model.GeofenceGeometry.Builder.() -> kotlin.Unit) {
            this.geometry = aws.sdk.kotlin.services.location.model.GeofenceGeometry.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (collectionName == null) collectionName = ""
            if (geofenceId == null) geofenceId = ""
            return this
        }
    }
}
