// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the map tile style selected from an available provider.
 */
public class MapConfiguration private constructor(builder: Builder) {
    /**
     * Specifies the custom layers for the style. Leave unset to not enable any custom layer, or, for styles that support custom layers, you can enable layer(s), such as POI layer for the VectorEsriNavigation style. Default is `unset`.
     *
     * Not all map resources or styles support custom layers. See Custom Layers for more information.
     */
    public val customLayers: List<String>? = builder.customLayers
    /**
     * Specifies the political view for the style. Leave unset to not use a political view, or, for styles that support specific political views, you can choose a view, such as `IND` for the Indian view.
     *
     * Default is unset.
     *
     * Not all map resources or styles support political view styles. See [Political views](https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html#political-views) for more information.
     */
    public val politicalView: kotlin.String? = builder.politicalView
    /**
     * Specifies the map style selected from an available data provider.
     *
     * Valid [Esri map styles](https://docs.aws.amazon.com/location/latest/developerguide/esri.html):
     * + `VectorEsriDarkGrayCanvas` – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content.
     * + `RasterEsriImagery` – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide.
     * + `VectorEsriLightGrayCanvas` – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content.
     * + `VectorEsriTopographic` – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.
     * + `VectorEsriStreets` – The Esri Street Map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.
     * + `VectorEsriNavigation` – The Esri Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.
     *
     * Valid [HERE Technologies map styles](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html):
     * + `VectorHereContrast` – The HERE Contrast (Berlin) map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.The `VectorHereContrast` style has been renamed from `VectorHereBerlin`. `VectorHereBerlin` has been deprecated, but will continue to work in applications that use it.
     * + `VectorHereExplore` – A default HERE map style containing a neutral, global map and its features including roads, buildings, landmarks, and water features. It also now includes a fully designed map of Japan.
     * + `VectorHereExploreTruck` – A global map containing truck restrictions and attributes (e.g. width / height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support use cases within transport and logistics.
     * + `RasterHereExploreSatellite` – A global map containing high resolution satellite imagery.
     * + `HybridHereExploreSatellite` – A global map displaying the road network, street names, and city labels over satellite imagery. This style will automatically retrieve both raster and vector tiles, and your charges will be based on total tiles retrieved.Hybrid styles use both vector and raster tiles when rendering the map that you see. This means that more tiles are retrieved than when using either vector or raster tiles alone. Your charges will include all tiles retrieved.
     *
     * Valid [GrabMaps map styles](https://docs.aws.amazon.com/location/latest/developerguide/grab.html):
     * + `VectorGrabStandardLight` – The Grab Standard Light map style provides a basemap with detailed land use coloring, area names, roads, landmarks, and points of interest covering Southeast Asia.
     * + `VectorGrabStandardDark` – The Grab Standard Dark map style provides a dark variation of the standard basemap covering Southeast Asia.
     *
     * Grab provides maps only for countries in Southeast Asia, and is only available in the Asia Pacific (Singapore) Region (`ap-southeast-1`). For more information, see [GrabMaps countries and area covered](https://docs.aws.amazon.com/location/latest/developerguide/grab.html#grab-coverage-area).
     *
     * Valid [Open Data map styles](https://docs.aws.amazon.com/location/latest/developerguide/open-data.html):
     * + `VectorOpenDataStandardLight` – The Open Data Standard Light map style provides a detailed basemap for the world suitable for website and mobile application use. The map includes highways major roads, minor roads, railways, water features, cities, parks, landmarks, building footprints, and administrative boundaries.
     * + `VectorOpenDataStandardDark` – Open Data Standard Dark is a dark-themed map style that provides a detailed basemap for the world suitable for website and mobile application use. The map includes highways major roads, minor roads, railways, water features, cities, parks, landmarks, building footprints, and administrative boundaries.
     * + `VectorOpenDataVisualizationLight` – The Open Data Visualization Light map style is a light-themed style with muted colors and fewer features that aids in understanding overlaid data.
     * + `VectorOpenDataVisualizationDark` – The Open Data Visualization Dark map style is a dark-themed style with muted colors and fewer features that aids in understanding overlaid data.
     */
    public val style: kotlin.String = requireNotNull(builder.style) { "A non-null value must be provided for style" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.MapConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MapConfiguration(")
        append("customLayers=$customLayers,")
        append("politicalView=$politicalView,")
        append("style=$style")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customLayers?.hashCode() ?: 0
        result = 31 * result + (politicalView?.hashCode() ?: 0)
        result = 31 * result + (style.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MapConfiguration

        if (customLayers != other.customLayers) return false
        if (politicalView != other.politicalView) return false
        if (style != other.style) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.MapConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the custom layers for the style. Leave unset to not enable any custom layer, or, for styles that support custom layers, you can enable layer(s), such as POI layer for the VectorEsriNavigation style. Default is `unset`.
         *
         * Not all map resources or styles support custom layers. See Custom Layers for more information.
         */
        public var customLayers: List<String>? = null
        /**
         * Specifies the political view for the style. Leave unset to not use a political view, or, for styles that support specific political views, you can choose a view, such as `IND` for the Indian view.
         *
         * Default is unset.
         *
         * Not all map resources or styles support political view styles. See [Political views](https://docs.aws.amazon.com/location/latest/developerguide/map-concepts.html#political-views) for more information.
         */
        public var politicalView: kotlin.String? = null
        /**
         * Specifies the map style selected from an available data provider.
         *
         * Valid [Esri map styles](https://docs.aws.amazon.com/location/latest/developerguide/esri.html):
         * + `VectorEsriDarkGrayCanvas` – The Esri Dark Gray Canvas map style. A vector basemap with a dark gray, neutral background with minimal colors, labels, and features that's designed to draw attention to your thematic content.
         * + `RasterEsriImagery` – The Esri Imagery map style. A raster basemap that provides one meter or better satellite and aerial imagery in many parts of the world and lower resolution satellite imagery worldwide.
         * + `VectorEsriLightGrayCanvas` – The Esri Light Gray Canvas map style, which provides a detailed vector basemap with a light gray, neutral background style with minimal colors, labels, and features that's designed to draw attention to your thematic content.
         * + `VectorEsriTopographic` – The Esri Light map style, which provides a detailed vector basemap with a classic Esri map style.
         * + `VectorEsriStreets` – The Esri Street Map style, which provides a detailed vector basemap for the world symbolized with a classic Esri street map style. The vector tile layer is similar in content and style to the World Street Map raster map.
         * + `VectorEsriNavigation` – The Esri Navigation map style, which provides a detailed basemap for the world symbolized with a custom navigation map style that's designed for use during the day in mobile devices.
         *
         * Valid [HERE Technologies map styles](https://docs.aws.amazon.com/location/latest/developerguide/HERE.html):
         * + `VectorHereContrast` – The HERE Contrast (Berlin) map style is a high contrast detailed base map of the world that blends 3D and 2D rendering.The `VectorHereContrast` style has been renamed from `VectorHereBerlin`. `VectorHereBerlin` has been deprecated, but will continue to work in applications that use it.
         * + `VectorHereExplore` – A default HERE map style containing a neutral, global map and its features including roads, buildings, landmarks, and water features. It also now includes a fully designed map of Japan.
         * + `VectorHereExploreTruck` – A global map containing truck restrictions and attributes (e.g. width / height / HAZMAT) symbolized with highlighted segments and icons on top of HERE Explore to support use cases within transport and logistics.
         * + `RasterHereExploreSatellite` – A global map containing high resolution satellite imagery.
         * + `HybridHereExploreSatellite` – A global map displaying the road network, street names, and city labels over satellite imagery. This style will automatically retrieve both raster and vector tiles, and your charges will be based on total tiles retrieved.Hybrid styles use both vector and raster tiles when rendering the map that you see. This means that more tiles are retrieved than when using either vector or raster tiles alone. Your charges will include all tiles retrieved.
         *
         * Valid [GrabMaps map styles](https://docs.aws.amazon.com/location/latest/developerguide/grab.html):
         * + `VectorGrabStandardLight` – The Grab Standard Light map style provides a basemap with detailed land use coloring, area names, roads, landmarks, and points of interest covering Southeast Asia.
         * + `VectorGrabStandardDark` – The Grab Standard Dark map style provides a dark variation of the standard basemap covering Southeast Asia.
         *
         * Grab provides maps only for countries in Southeast Asia, and is only available in the Asia Pacific (Singapore) Region (`ap-southeast-1`). For more information, see [GrabMaps countries and area covered](https://docs.aws.amazon.com/location/latest/developerguide/grab.html#grab-coverage-area).
         *
         * Valid [Open Data map styles](https://docs.aws.amazon.com/location/latest/developerguide/open-data.html):
         * + `VectorOpenDataStandardLight` – The Open Data Standard Light map style provides a detailed basemap for the world suitable for website and mobile application use. The map includes highways major roads, minor roads, railways, water features, cities, parks, landmarks, building footprints, and administrative boundaries.
         * + `VectorOpenDataStandardDark` – Open Data Standard Dark is a dark-themed map style that provides a detailed basemap for the world suitable for website and mobile application use. The map includes highways major roads, minor roads, railways, water features, cities, parks, landmarks, building footprints, and administrative boundaries.
         * + `VectorOpenDataVisualizationLight` – The Open Data Visualization Light map style is a light-themed style with muted colors and fewer features that aids in understanding overlaid data.
         * + `VectorOpenDataVisualizationDark` – The Open Data Visualization Dark map style is a dark-themed style with muted colors and fewer features that aids in understanding overlaid data.
         */
        public var style: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.MapConfiguration) : this() {
            this.customLayers = x.customLayers
            this.politicalView = x.politicalView
            this.style = x.style
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.MapConfiguration = MapConfiguration(this)

        internal fun correctErrors(): Builder {
            if (style == null) style = ""
            return this
        }
    }
}
