// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about the Long-Term Evolution (LTE) network.
 */
public class LteCellDetails private constructor(builder: Builder) {
    /**
     * The E-UTRAN Cell Identifier (ECI).
     */
    public val cellId: kotlin.Int = builder.cellId
    /**
     * The LTE local identification information (local ID).
     */
    public val localId: aws.sdk.kotlin.services.location.model.LteLocalId? = builder.localId
    /**
     * The Mobile Country Code (MCC).
     */
    public val mcc: kotlin.Int = requireNotNull(builder.mcc) { "A non-null value must be provided for mcc" }
    /**
     * The Mobile Network Code (MNC)
     */
    public val mnc: kotlin.Int = requireNotNull(builder.mnc) { "A non-null value must be provided for mnc" }
    /**
     * The network measurements.
     */
    public val networkMeasurements: List<LteNetworkMeasurements>? = builder.networkMeasurements
    /**
     * Indicates whether the LTE object is capable of supporting NR (new radio).
     */
    public val nrCapable: kotlin.Boolean? = builder.nrCapable
    /**
     * Signal power of the reference signal received, measured in decibel-milliwatts (dBm).
     */
    public val rsrp: kotlin.Int? = builder.rsrp
    /**
     * Signal quality of the reference Signal received, measured in decibels (dB).
     */
    public val rsrq: kotlin.Float? = builder.rsrq
    /**
     * LTE Tracking Area Code (TAC).
     */
    public val tac: kotlin.Int? = builder.tac
    /**
     * Timing Advance (TA).
     */
    public val timingAdvance: kotlin.Int? = builder.timingAdvance

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.LteCellDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LteCellDetails(")
        append("cellId=$cellId,")
        append("localId=$localId,")
        append("mcc=$mcc,")
        append("mnc=$mnc,")
        append("networkMeasurements=$networkMeasurements,")
        append("nrCapable=$nrCapable,")
        append("rsrp=$rsrp,")
        append("rsrq=$rsrq,")
        append("tac=$tac,")
        append("timingAdvance=$timingAdvance")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cellId
        result = 31 * result + (localId?.hashCode() ?: 0)
        result = 31 * result + (mcc)
        result = 31 * result + (mnc)
        result = 31 * result + (networkMeasurements?.hashCode() ?: 0)
        result = 31 * result + (nrCapable?.hashCode() ?: 0)
        result = 31 * result + (rsrp ?: 0)
        result = 31 * result + (rsrq?.hashCode() ?: 0)
        result = 31 * result + (tac ?: 0)
        result = 31 * result + (timingAdvance ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LteCellDetails

        if (cellId != other.cellId) return false
        if (localId != other.localId) return false
        if (mcc != other.mcc) return false
        if (mnc != other.mnc) return false
        if (networkMeasurements != other.networkMeasurements) return false
        if (nrCapable != other.nrCapable) return false
        if (rsrp != other.rsrp) return false
        if (!(rsrq?.equals(other.rsrq) ?: (other.rsrq == null))) return false
        if (tac != other.tac) return false
        if (timingAdvance != other.timingAdvance) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.LteCellDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The E-UTRAN Cell Identifier (ECI).
         */
        public var cellId: kotlin.Int = 0
        /**
         * The LTE local identification information (local ID).
         */
        public var localId: aws.sdk.kotlin.services.location.model.LteLocalId? = null
        /**
         * The Mobile Country Code (MCC).
         */
        public var mcc: kotlin.Int? = null
        /**
         * The Mobile Network Code (MNC)
         */
        public var mnc: kotlin.Int? = null
        /**
         * The network measurements.
         */
        public var networkMeasurements: List<LteNetworkMeasurements>? = null
        /**
         * Indicates whether the LTE object is capable of supporting NR (new radio).
         */
        public var nrCapable: kotlin.Boolean? = null
        /**
         * Signal power of the reference signal received, measured in decibel-milliwatts (dBm).
         */
        public var rsrp: kotlin.Int? = null
        /**
         * Signal quality of the reference Signal received, measured in decibels (dB).
         */
        public var rsrq: kotlin.Float? = null
        /**
         * LTE Tracking Area Code (TAC).
         */
        public var tac: kotlin.Int? = null
        /**
         * Timing Advance (TA).
         */
        public var timingAdvance: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.LteCellDetails) : this() {
            this.cellId = x.cellId
            this.localId = x.localId
            this.mcc = x.mcc
            this.mnc = x.mnc
            this.networkMeasurements = x.networkMeasurements
            this.nrCapable = x.nrCapable
            this.rsrp = x.rsrp
            this.rsrq = x.rsrq
            this.tac = x.tac
            this.timingAdvance = x.timingAdvance
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.LteCellDetails = LteCellDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.LteLocalId] inside the given [block]
         */
        public fun localId(block: aws.sdk.kotlin.services.location.model.LteLocalId.Builder.() -> kotlin.Unit) {
            this.localId = aws.sdk.kotlin.services.location.model.LteLocalId.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (mcc == null) mcc = 0
            if (mnc == null) mnc = 0
            return this
        }
    }
}
