// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The inferred state of the device, given the provided position, IP address, cellular signals, and Wi-Fi- access points.
 */
public class InferredState private constructor(builder: Builder) {
    /**
     * The level of certainty of the inferred position.
     */
    public val accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = builder.accuracy
    /**
     * The distance between the inferred position and the device's self-reported position.
     */
    public val deviationDistance: kotlin.Double? = builder.deviationDistance
    /**
     * The device position inferred by the provided position, IP address, cellular signals, and Wi-Fi- access points.
     */
    public val position: List<Double>? = builder.position
    /**
     * Indicates if a proxy was used.
     */
    public val proxyDetected: kotlin.Boolean = requireNotNull(builder.proxyDetected) { "A non-null value must be provided for proxyDetected" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.InferredState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferredState(")
        append("accuracy=$accuracy,")
        append("deviationDistance=$deviationDistance,")
        append("position=*** Sensitive Data Redacted ***,")
        append("proxyDetected=$proxyDetected")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accuracy?.hashCode() ?: 0
        result = 31 * result + (deviationDistance?.hashCode() ?: 0)
        result = 31 * result + (position?.hashCode() ?: 0)
        result = 31 * result + (proxyDetected.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferredState

        if (accuracy != other.accuracy) return false
        if (!(deviationDistance?.equals(other.deviationDistance) ?: (other.deviationDistance == null))) return false
        if (position != other.position) return false
        if (proxyDetected != other.proxyDetected) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.InferredState = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The level of certainty of the inferred position.
         */
        public var accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = null
        /**
         * The distance between the inferred position and the device's self-reported position.
         */
        public var deviationDistance: kotlin.Double? = null
        /**
         * The device position inferred by the provided position, IP address, cellular signals, and Wi-Fi- access points.
         */
        public var position: List<Double>? = null
        /**
         * Indicates if a proxy was used.
         */
        public var proxyDetected: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.InferredState) : this() {
            this.accuracy = x.accuracy
            this.deviationDistance = x.deviationDistance
            this.position = x.position
            this.proxyDetected = x.proxyDetected
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.InferredState = InferredState(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.PositionalAccuracy] inside the given [block]
         */
        public fun accuracy(block: aws.sdk.kotlin.services.location.model.PositionalAccuracy.Builder.() -> kotlin.Unit) {
            this.accuracy = aws.sdk.kotlin.services.location.model.PositionalAccuracy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (proxyDetected == null) proxyDetected = false
            return this
        }
    }
}
