// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the geofence geometry details.
 *
 * A geofence geometry is made up of either a polygon or a circle. Can be a polygon, a circle or a polygon encoded in Geobuf format. Including multiple selections will return a validation error.
 *
 * Amazon Location doesn't currently support polygons with holes, multipolygons, polygons that are wound clockwise, or that cross the antimeridian.
 */
public class GeofenceGeometry private constructor(builder: Builder) {
    /**
     * A circle on the earth, as defined by a center point and a radius.
     */
    public val circle: aws.sdk.kotlin.services.location.model.Circle? = builder.circle
    /**
     * Geobuf is a compact binary encoding for geographic data that provides lossless compression of GeoJSON polygons. The Geobuf must be Base64-encoded.
     *
     * A polygon in Geobuf format can have up to 100,000 vertices.
     */
    public val geobuf: kotlin.ByteArray? = builder.geobuf
    /**
     * A polygon is a list of linear rings which are each made up of a list of vertices.
     *
     * Each vertex is a 2-dimensional point of the form: `[longitude, latitude]`. This is represented as an array of doubles of length 2 (so `[double, double]`).
     *
     * An array of 4 or more vertices, where the first and last vertex are the same (to form a closed boundary), is called a linear ring. The linear ring vertices must be listed in counter-clockwise order around the ring’s interior. The linear ring is represented as an array of vertices, or an array of arrays of doubles (`[[double, double], ...]`).
     *
     * A geofence consists of a single linear ring. To allow for future expansion, the Polygon parameter takes an array of linear rings, which is represented as an array of arrays of arrays of doubles (`[[[double, double], ...], ...]`).
     *
     * A linear ring for use in geofences can consist of between 4 and 1,000 vertices.
     */
    public val polygon: List<List<List<Double>>>? = builder.polygon

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.GeofenceGeometry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GeofenceGeometry(")
        append("circle=*** Sensitive Data Redacted ***,")
        append("geobuf=*** Sensitive Data Redacted ***,")
        append("polygon=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = circle?.hashCode() ?: 0
        result = 31 * result + (geobuf?.contentHashCode() ?: 0)
        result = 31 * result + (polygon?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GeofenceGeometry

        if (circle != other.circle) return false
        if (geobuf != null) {
            if (other.geobuf == null) return false
            if (!geobuf.contentEquals(other.geobuf)) return false
        } else if (other.geobuf != null) return false
        if (polygon != other.polygon) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.GeofenceGeometry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A circle on the earth, as defined by a center point and a radius.
         */
        public var circle: aws.sdk.kotlin.services.location.model.Circle? = null
        /**
         * Geobuf is a compact binary encoding for geographic data that provides lossless compression of GeoJSON polygons. The Geobuf must be Base64-encoded.
         *
         * A polygon in Geobuf format can have up to 100,000 vertices.
         */
        public var geobuf: kotlin.ByteArray? = null
        /**
         * A polygon is a list of linear rings which are each made up of a list of vertices.
         *
         * Each vertex is a 2-dimensional point of the form: `[longitude, latitude]`. This is represented as an array of doubles of length 2 (so `[double, double]`).
         *
         * An array of 4 or more vertices, where the first and last vertex are the same (to form a closed boundary), is called a linear ring. The linear ring vertices must be listed in counter-clockwise order around the ring’s interior. The linear ring is represented as an array of vertices, or an array of arrays of doubles (`[[double, double], ...]`).
         *
         * A geofence consists of a single linear ring. To allow for future expansion, the Polygon parameter takes an array of linear rings, which is represented as an array of arrays of arrays of doubles (`[[[double, double], ...], ...]`).
         *
         * A linear ring for use in geofences can consist of between 4 and 1,000 vertices.
         */
        public var polygon: List<List<List<Double>>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.GeofenceGeometry) : this() {
            this.circle = x.circle
            this.geobuf = x.geobuf
            this.polygon = x.polygon
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.GeofenceGeometry = GeofenceGeometry(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.Circle] inside the given [block]
         */
        public fun circle(block: aws.sdk.kotlin.services.location.model.Circle.Builder.() -> kotlin.Unit) {
            this.circle = aws.sdk.kotlin.services.location.model.Circle.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
