// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A forecasted event represents a geofence event in relation to the requested device state, that may occur given the provided device state and time horizon.
 */
public class ForecastedEvent private constructor(builder: Builder) {
    /**
     * The forecasted event identifier.
     */
    public val eventId: kotlin.String = requireNotNull(builder.eventId) { "A non-null value must be provided for eventId" }
    /**
     * The event type, forecasting three states for which a device can be in relative to a geofence:
     *
     * `ENTER`: If a device is outside of a geofence, but would breach the fence if the device is moving at its current speed within time horizon window.
     *
     * `EXIT`: If a device is inside of a geofence, but would breach the fence if the device is moving at its current speed within time horizon window.
     *
     * `IDLE`: If a device is inside of a geofence, and the device is not moving.
     */
    public val eventType: aws.sdk.kotlin.services.location.model.ForecastedGeofenceEventType = requireNotNull(builder.eventType) { "A non-null value must be provided for eventType" }
    /**
     * The forecasted time the device will breach the geofence in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val forecastedBreachTime: aws.smithy.kotlin.runtime.time.Instant? = builder.forecastedBreachTime
    /**
     * The geofence identifier pertaining to the forecasted event.
     */
    public val geofenceId: kotlin.String = requireNotNull(builder.geofenceId) { "A non-null value must be provided for geofenceId" }
    /**
     * The geofence properties.
     */
    public val geofenceProperties: Map<String, String>? = builder.geofenceProperties
    /**
     * Indicates if the device is located within the geofence.
     */
    public val isDeviceInGeofence: kotlin.Boolean = requireNotNull(builder.isDeviceInGeofence) { "A non-null value must be provided for isDeviceInGeofence" }
    /**
     * The closest distance from the device's position to the geofence.
     */
    public val nearestDistance: kotlin.Double = builder.nearestDistance

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ForecastedEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ForecastedEvent(")
        append("eventId=$eventId,")
        append("eventType=$eventType,")
        append("forecastedBreachTime=$forecastedBreachTime,")
        append("geofenceId=$geofenceId,")
        append("geofenceProperties=*** Sensitive Data Redacted ***,")
        append("isDeviceInGeofence=$isDeviceInGeofence,")
        append("nearestDistance=$nearestDistance")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventId.hashCode()
        result = 31 * result + (eventType.hashCode())
        result = 31 * result + (forecastedBreachTime?.hashCode() ?: 0)
        result = 31 * result + (geofenceId.hashCode())
        result = 31 * result + (geofenceProperties?.hashCode() ?: 0)
        result = 31 * result + (isDeviceInGeofence.hashCode())
        result = 31 * result + (nearestDistance.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ForecastedEvent

        if (eventId != other.eventId) return false
        if (eventType != other.eventType) return false
        if (forecastedBreachTime != other.forecastedBreachTime) return false
        if (geofenceId != other.geofenceId) return false
        if (geofenceProperties != other.geofenceProperties) return false
        if (isDeviceInGeofence != other.isDeviceInGeofence) return false
        if (!(nearestDistance?.equals(other.nearestDistance) ?: (other.nearestDistance == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ForecastedEvent = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The forecasted event identifier.
         */
        public var eventId: kotlin.String? = null
        /**
         * The event type, forecasting three states for which a device can be in relative to a geofence:
         *
         * `ENTER`: If a device is outside of a geofence, but would breach the fence if the device is moving at its current speed within time horizon window.
         *
         * `EXIT`: If a device is inside of a geofence, but would breach the fence if the device is moving at its current speed within time horizon window.
         *
         * `IDLE`: If a device is inside of a geofence, and the device is not moving.
         */
        public var eventType: aws.sdk.kotlin.services.location.model.ForecastedGeofenceEventType? = null
        /**
         * The forecasted time the device will breach the geofence in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var forecastedBreachTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The geofence identifier pertaining to the forecasted event.
         */
        public var geofenceId: kotlin.String? = null
        /**
         * The geofence properties.
         */
        public var geofenceProperties: Map<String, String>? = null
        /**
         * Indicates if the device is located within the geofence.
         */
        public var isDeviceInGeofence: kotlin.Boolean? = null
        /**
         * The closest distance from the device's position to the geofence.
         */
        public var nearestDistance: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ForecastedEvent) : this() {
            this.eventId = x.eventId
            this.eventType = x.eventType
            this.forecastedBreachTime = x.forecastedBreachTime
            this.geofenceId = x.geofenceId
            this.geofenceProperties = x.geofenceProperties
            this.isDeviceInGeofence = x.isDeviceInGeofence
            this.nearestDistance = x.nearestDistance
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ForecastedEvent = ForecastedEvent(this)

        internal fun correctErrors(): Builder {
            if (eventId == null) eventId = ""
            if (eventType == null) eventType = ForecastedGeofenceEventType.SdkUnknown("no value provided")
            if (geofenceId == null) geofenceId = ""
            if (isDeviceInGeofence == null) isDeviceInGeofence = false
            return this
        }
    }
}
