// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The device's position, IP address, and Wi-Fi access points.
 */
public class DeviceState private constructor(builder: Builder) {
    /**
     * Defines the level of certainty of the position.
     */
    public val accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = builder.accuracy
    /**
     * The cellular network infrastructure that the device is connected to.
     */
    public val cellSignals: aws.sdk.kotlin.services.location.model.CellSignals? = builder.cellSignals
    /**
     * The device identifier.
     */
    public val deviceId: kotlin.String = requireNotNull(builder.deviceId) { "A non-null value must be provided for deviceId" }
    /**
     * The device's Ipv4 address.
     */
    public val ipv4Address: kotlin.String? = builder.ipv4Address
    /**
     * The last known device position.
     */
    public val position: List<Double> = requireNotNull(builder.position) { "A non-null value must be provided for position" }
    /**
     * The timestamp at which the device's position was determined. Uses [ ISO 8601 ](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val sampleTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.sampleTime) { "A non-null value must be provided for sampleTime" }
    /**
     * The Wi-Fi access points the device is using.
     */
    public val wiFiAccessPoints: List<WiFiAccessPoint>? = builder.wiFiAccessPoints

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DeviceState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceState(")
        append("accuracy=$accuracy,")
        append("cellSignals=$cellSignals,")
        append("deviceId=$deviceId,")
        append("ipv4Address=$ipv4Address,")
        append("position=*** Sensitive Data Redacted ***,")
        append("sampleTime=$sampleTime,")
        append("wiFiAccessPoints=$wiFiAccessPoints")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accuracy?.hashCode() ?: 0
        result = 31 * result + (cellSignals?.hashCode() ?: 0)
        result = 31 * result + (deviceId.hashCode())
        result = 31 * result + (ipv4Address?.hashCode() ?: 0)
        result = 31 * result + (position.hashCode())
        result = 31 * result + (sampleTime.hashCode())
        result = 31 * result + (wiFiAccessPoints?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeviceState

        if (accuracy != other.accuracy) return false
        if (cellSignals != other.cellSignals) return false
        if (deviceId != other.deviceId) return false
        if (ipv4Address != other.ipv4Address) return false
        if (position != other.position) return false
        if (sampleTime != other.sampleTime) return false
        if (wiFiAccessPoints != other.wiFiAccessPoints) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DeviceState = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines the level of certainty of the position.
         */
        public var accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = null
        /**
         * The cellular network infrastructure that the device is connected to.
         */
        public var cellSignals: aws.sdk.kotlin.services.location.model.CellSignals? = null
        /**
         * The device identifier.
         */
        public var deviceId: kotlin.String? = null
        /**
         * The device's Ipv4 address.
         */
        public var ipv4Address: kotlin.String? = null
        /**
         * The last known device position.
         */
        public var position: List<Double>? = null
        /**
         * The timestamp at which the device's position was determined. Uses [ ISO 8601 ](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var sampleTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Wi-Fi access points the device is using.
         */
        public var wiFiAccessPoints: List<WiFiAccessPoint>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DeviceState) : this() {
            this.accuracy = x.accuracy
            this.cellSignals = x.cellSignals
            this.deviceId = x.deviceId
            this.ipv4Address = x.ipv4Address
            this.position = x.position
            this.sampleTime = x.sampleTime
            this.wiFiAccessPoints = x.wiFiAccessPoints
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DeviceState = DeviceState(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.PositionalAccuracy] inside the given [block]
         */
        public fun accuracy(block: aws.sdk.kotlin.services.location.model.PositionalAccuracy.Builder.() -> kotlin.Unit) {
            this.accuracy = aws.sdk.kotlin.services.location.model.PositionalAccuracy.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.location.model.CellSignals] inside the given [block]
         */
        public fun cellSignals(block: aws.sdk.kotlin.services.location.model.CellSignals.Builder.() -> kotlin.Unit) {
            this.cellSignals = aws.sdk.kotlin.services.location.model.CellSignals.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (deviceId == null) deviceId = ""
            if (position == null) position = emptyList()
            if (sampleTime == null) sampleTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
