// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the position update details for a device.
 */
public class DevicePositionUpdate private constructor(builder: Builder) {
    /**
     * The accuracy of the device position.
     */
    public val accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = builder.accuracy
    /**
     * The device associated to the position update.
     */
    public val deviceId: kotlin.String = requireNotNull(builder.deviceId) { "A non-null value must be provided for deviceId" }
    /**
     * The latest device position defined in [WGS 84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format: `[X or longitude, Y or latitude]`.
     */
    public val position: List<Double> = requireNotNull(builder.position) { "A non-null value must be provided for position" }
    /**
     * Associates one of more properties with the position update. A property is a key-value pair stored with the position update and added to any geofence event the update may trigger.
     *
     * Format: `"key" : "value"`
     */
    public val positionProperties: Map<String, String>? = builder.positionProperties
    /**
     * The timestamp at which the device's position was determined. Uses [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val sampleTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.sampleTime) { "A non-null value must be provided for sampleTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DevicePositionUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DevicePositionUpdate(")
        append("accuracy=$accuracy,")
        append("deviceId=$deviceId,")
        append("position=*** Sensitive Data Redacted ***,")
        append("positionProperties=*** Sensitive Data Redacted ***,")
        append("sampleTime=$sampleTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accuracy?.hashCode() ?: 0
        result = 31 * result + (deviceId.hashCode())
        result = 31 * result + (position.hashCode())
        result = 31 * result + (positionProperties?.hashCode() ?: 0)
        result = 31 * result + (sampleTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DevicePositionUpdate

        if (accuracy != other.accuracy) return false
        if (deviceId != other.deviceId) return false
        if (position != other.position) return false
        if (positionProperties != other.positionProperties) return false
        if (sampleTime != other.sampleTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DevicePositionUpdate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The accuracy of the device position.
         */
        public var accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = null
        /**
         * The device associated to the position update.
         */
        public var deviceId: kotlin.String? = null
        /**
         * The latest device position defined in [WGS 84](https://earth-info.nga.mil/index.php?dir=wgs84&action=wgs84) format: `[X or longitude, Y or latitude]`.
         */
        public var position: List<Double>? = null
        /**
         * Associates one of more properties with the position update. A property is a key-value pair stored with the position update and added to any geofence event the update may trigger.
         *
         * Format: `"key" : "value"`
         */
        public var positionProperties: Map<String, String>? = null
        /**
         * The timestamp at which the device's position was determined. Uses [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var sampleTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DevicePositionUpdate) : this() {
            this.accuracy = x.accuracy
            this.deviceId = x.deviceId
            this.position = x.position
            this.positionProperties = x.positionProperties
            this.sampleTime = x.sampleTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DevicePositionUpdate = DevicePositionUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.PositionalAccuracy] inside the given [block]
         */
        public fun accuracy(block: aws.sdk.kotlin.services.location.model.PositionalAccuracy.Builder.() -> kotlin.Unit) {
            this.accuracy = aws.sdk.kotlin.services.location.model.PositionalAccuracy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (deviceId == null) deviceId = ""
            if (position == null) position = emptyList()
            if (sampleTime == null) sampleTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
