// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the device position details.
 */
public class DevicePosition private constructor(builder: Builder) {
    /**
     * The accuracy of the device position.
     */
    public val accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = builder.accuracy
    /**
     * The device whose position you retrieved.
     */
    public val deviceId: kotlin.String? = builder.deviceId
    /**
     * The last known device position.
     */
    public val position: List<Double> = requireNotNull(builder.position) { "A non-null value must be provided for position" }
    /**
     * The properties associated with the position.
     */
    public val positionProperties: Map<String, String>? = builder.positionProperties
    /**
     * The timestamp for when the tracker resource received the device position in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val receivedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.receivedTime) { "A non-null value must be provided for receivedTime" }
    /**
     * The timestamp at which the device's position was determined. Uses [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val sampleTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.sampleTime) { "A non-null value must be provided for sampleTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DevicePosition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DevicePosition(")
        append("accuracy=$accuracy,")
        append("deviceId=$deviceId,")
        append("position=*** Sensitive Data Redacted ***,")
        append("positionProperties=*** Sensitive Data Redacted ***,")
        append("receivedTime=$receivedTime,")
        append("sampleTime=$sampleTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accuracy?.hashCode() ?: 0
        result = 31 * result + (deviceId?.hashCode() ?: 0)
        result = 31 * result + (position.hashCode())
        result = 31 * result + (positionProperties?.hashCode() ?: 0)
        result = 31 * result + (receivedTime.hashCode())
        result = 31 * result + (sampleTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DevicePosition

        if (accuracy != other.accuracy) return false
        if (deviceId != other.deviceId) return false
        if (position != other.position) return false
        if (positionProperties != other.positionProperties) return false
        if (receivedTime != other.receivedTime) return false
        if (sampleTime != other.sampleTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DevicePosition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The accuracy of the device position.
         */
        public var accuracy: aws.sdk.kotlin.services.location.model.PositionalAccuracy? = null
        /**
         * The device whose position you retrieved.
         */
        public var deviceId: kotlin.String? = null
        /**
         * The last known device position.
         */
        public var position: List<Double>? = null
        /**
         * The properties associated with the position.
         */
        public var positionProperties: Map<String, String>? = null
        /**
         * The timestamp for when the tracker resource received the device position in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var receivedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The timestamp at which the device's position was determined. Uses [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var sampleTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DevicePosition) : this() {
            this.accuracy = x.accuracy
            this.deviceId = x.deviceId
            this.position = x.position
            this.positionProperties = x.positionProperties
            this.receivedTime = x.receivedTime
            this.sampleTime = x.sampleTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DevicePosition = DevicePosition(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.PositionalAccuracy] inside the given [block]
         */
        public fun accuracy(block: aws.sdk.kotlin.services.location.model.PositionalAccuracy.Builder.() -> kotlin.Unit) {
            this.accuracy = aws.sdk.kotlin.services.location.model.PositionalAccuracy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (position == null) position = emptyList()
            if (receivedTime == null) receivedTime = Instant.fromEpochSeconds(0)
            if (sampleTime == null) sampleTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
