// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeMapResponse private constructor(builder: Builder) {
    /**
     * Specifies the map tile style selected from a partner data provider.
     */
    public val configuration: aws.sdk.kotlin.services.location.model.MapConfiguration? = builder.configuration
    /**
     * The timestamp for when the map resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * Specifies the data provider for the associated map tiles.
     */
    public val dataSource: kotlin.String = requireNotNull(builder.dataSource) { "A non-null value must be provided for dataSource" }
    /**
     * The optional description for the map resource.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:map/ExampleMap`
     */
    public val mapArn: kotlin.String = requireNotNull(builder.mapArn) { "A non-null value must be provided for mapArn" }
    /**
     * The map style selected from an available provider.
     */
    public val mapName: kotlin.String = requireNotNull(builder.mapName) { "A non-null value must be provided for mapName" }
    /**
     * Tags associated with the map resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The timestamp for when the map resource was last update in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribeMapResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeMapResponse(")
        append("configuration=$configuration,")
        append("createTime=$createTime,")
        append("dataSource=$dataSource,")
        append("description=$description,")
        append("mapArn=$mapArn,")
        append("mapName=$mapName,")
        append("tags=$tags,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (dataSource.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (mapArn.hashCode())
        result = 31 * result + (mapName.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeMapResponse

        if (configuration != other.configuration) return false
        if (createTime != other.createTime) return false
        if (dataSource != other.dataSource) return false
        if (description != other.description) return false
        if (mapArn != other.mapArn) return false
        if (mapName != other.mapName) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribeMapResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the map tile style selected from a partner data provider.
         */
        public var configuration: aws.sdk.kotlin.services.location.model.MapConfiguration? = null
        /**
         * The timestamp for when the map resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the data provider for the associated map tiles.
         */
        public var dataSource: kotlin.String? = null
        /**
         * The optional description for the map resource.
         */
        public var description: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the map resource. Used to specify a resource across all Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:map/ExampleMap`
         */
        public var mapArn: kotlin.String? = null
        /**
         * The map style selected from an available provider.
         */
        public var mapName: kotlin.String? = null
        /**
         * Tags associated with the map resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The timestamp for when the map resource was last update in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribeMapResponse) : this() {
            this.configuration = x.configuration
            this.createTime = x.createTime
            this.dataSource = x.dataSource
            this.description = x.description
            this.mapArn = x.mapArn
            this.mapName = x.mapName
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribeMapResponse = DescribeMapResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.MapConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.location.model.MapConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.location.model.MapConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (dataSource == null) dataSource = ""
            if (description == null) description = ""
            if (mapArn == null) mapArn = ""
            if (mapName == null) mapName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
