// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateKeyRequest private constructor(builder: Builder) {
    /**
     * An optional description for the API key resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The optional timestamp for when the API key resource will expire in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. One of `NoExpiry` or `ExpireTime` must be set.
     */
    public val expireTime: aws.smithy.kotlin.runtime.time.Instant? = builder.expireTime
    /**
     * A custom name for the API key resource.
     *
     * Requirements:
     * + Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     * + Must be a unique API key name.
     * + No spaces allowed. For example, `ExampleAPIKey`.
     */
    public val keyName: kotlin.String = requireNotNull(builder.keyName) { "A non-null value must be provided for keyName" }
    /**
     * Optionally set to `true` to set no expiration time for the API key. One of `NoExpiry` or `ExpireTime` must be set.
     */
    public val noExpiry: kotlin.Boolean? = builder.noExpiry
    /**
     * The API key restrictions for the API key resource.
     */
    public val restrictions: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions? = builder.restrictions
    /**
     * Applies one or more tags to the map resource. A tag is a key-value pair that helps manage, identify, search, and filter your resources by labelling them.
     *
     * Format: `"key" : "value"`
     *
     * Restrictions:
     * + Maximum 50 tags per resource
     * + Each resource tag must be unique with a maximum of one value.
     * + Maximum key length: 128 Unicode characters in UTF-8
     * + Maximum value length: 256 Unicode characters in UTF-8
     * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     * + Cannot use "aws:" as a prefix for a key.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateKeyRequest(")
        append("description=$description,")
        append("expireTime=$expireTime,")
        append("keyName=$keyName,")
        append("noExpiry=$noExpiry,")
        append("restrictions=$restrictions,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (expireTime?.hashCode() ?: 0)
        result = 31 * result + (keyName.hashCode())
        result = 31 * result + (noExpiry?.hashCode() ?: 0)
        result = 31 * result + (restrictions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateKeyRequest

        if (description != other.description) return false
        if (expireTime != other.expireTime) return false
        if (keyName != other.keyName) return false
        if (noExpiry != other.noExpiry) return false
        if (restrictions != other.restrictions) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateKeyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional description for the API key resource.
         */
        public var description: kotlin.String? = null
        /**
         * The optional timestamp for when the API key resource will expire in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`. One of `NoExpiry` or `ExpireTime` must be set.
         */
        public var expireTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A custom name for the API key resource.
         *
         * Requirements:
         * + Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
         * + Must be a unique API key name.
         * + No spaces allowed. For example, `ExampleAPIKey`.
         */
        public var keyName: kotlin.String? = null
        /**
         * Optionally set to `true` to set no expiration time for the API key. One of `NoExpiry` or `ExpireTime` must be set.
         */
        public var noExpiry: kotlin.Boolean? = null
        /**
         * The API key restrictions for the API key resource.
         */
        public var restrictions: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions? = null
        /**
         * Applies one or more tags to the map resource. A tag is a key-value pair that helps manage, identify, search, and filter your resources by labelling them.
         *
         * Format: `"key" : "value"`
         *
         * Restrictions:
         * + Maximum 50 tags per resource
         * + Each resource tag must be unique with a maximum of one value.
         * + Maximum key length: 128 Unicode characters in UTF-8
         * + Maximum value length: 256 Unicode characters in UTF-8
         * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         * + Cannot use "aws:" as a prefix for a key.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateKeyRequest) : this() {
            this.description = x.description
            this.expireTime = x.expireTime
            this.keyName = x.keyName
            this.noExpiry = x.noExpiry
            this.restrictions = x.restrictions
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateKeyRequest = CreateKeyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.ApiKeyRestrictions] inside the given [block]
         */
        public fun restrictions(block: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions.Builder.() -> kotlin.Unit) {
            this.restrictions = aws.sdk.kotlin.services.location.model.ApiKeyRestrictions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (keyName == null) keyName = ""
            return this
        }
    }
}
