// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateGeofenceCollectionRequest private constructor(builder: Builder) {
    /**
     * A custom name for the geofence collection.
     *
     * Requirements:
     * + Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
     * + Must be a unique geofence collection name.
     * + No spaces allowed. For example, `ExampleGeofenceCollection`.
     */
    public val collectionName: kotlin.String = requireNotNull(builder.collectionName) { "A non-null value must be provided for collectionName" }
    /**
     * An optional description for the geofence collection.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A key identifier for an [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html). Enter a key ID, key ARN, alias name, or alias ARN.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
     *
     * Format: `"key" : "value"`
     *
     * Restrictions:
     * + Maximum 50 tags per resource
     * + Each resource tag must be unique with a maximum of one value.
     * + Maximum key length: 128 Unicode characters in UTF-8
     * + Maximum value length: 256 Unicode characters in UTF-8
     * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
     * + Cannot use "aws:" as a prefix for a key.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGeofenceCollectionRequest(")
        append("collectionName=$collectionName,")
        append("description=$description,")
        append("kmsKeyId=$kmsKeyId,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionName.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGeofenceCollectionRequest

        if (collectionName != other.collectionName) return false
        if (description != other.description) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A custom name for the geofence collection.
         *
         * Requirements:
         * + Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).
         * + Must be a unique geofence collection name.
         * + No spaces allowed. For example, `ExampleGeofenceCollection`.
         */
        public var collectionName: kotlin.String? = null
        /**
         * An optional description for the geofence collection.
         */
        public var description: kotlin.String? = null
        /**
         * A key identifier for an [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html). Enter a key ID, key ARN, alias name, or alias ARN.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * Applies one or more tags to the geofence collection. A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
         *
         * Format: `"key" : "value"`
         *
         * Restrictions:
         * + Maximum 50 tags per resource
         * + Each resource tag must be unique with a maximum of one value.
         * + Maximum key length: 128 Unicode characters in UTF-8
         * + Maximum value length: 256 Unicode characters in UTF-8
         * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @.
         * + Cannot use "aws:" as a prefix for a key.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionRequest) : this() {
            this.collectionName = x.collectionName
            this.description = x.description
            this.kmsKeyId = x.kmsKeyId
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionRequest = CreateGeofenceCollectionRequest(this)

        internal fun correctErrors(): Builder {
            if (collectionName == null) collectionName = ""
            return this
        }
    }
}
