// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * API Restrictions on the allowed actions, resources, and referers for an API key resource.
 */
public class ApiKeyRestrictions private constructor(builder: Builder) {
    /**
     * A list of allowed actions that an API key resource grants permissions to perform. You must have at least one action for each type of resource. For example, if you have a place resource, you must include at least one place action.
     *
     * The following are valid values for the actions.
     * + **Map actions**
     *    + `geo:GetMap*` - Allows all actions needed for map rendering.
     * + **Place actions**
     *    + `geo:SearchPlaceIndexForText` - Allows geocoding.
     *    + `geo:SearchPlaceIndexForPosition` - Allows reverse geocoding.
     *    + `geo:SearchPlaceIndexForSuggestions` - Allows generating suggestions from text.
     *    + `GetPlace` - Allows finding a place by place ID.
     * + **Route actions**
     *    + `geo:CalculateRoute` - Allows point to point routing.
     *    + `geo:CalculateRouteMatrix` - Allows calculating a matrix of routes.
     *
     * You must use these strings exactly. For example, to provide access to map rendering, the only valid action is `geo:GetMap*` as an input to the list. `["geo:GetMap*"]` is valid but `["geo:GetMapTile"]` is not. Similarly, you cannot use `["geo:SearchPlaceIndexFor*"]` - you must list each of the Place actions separately.
     */
    public val allowActions: List<String> = requireNotNull(builder.allowActions) { "A non-null value must be provided for allowActions" }
    /**
     * An optional list of allowed HTTP referers for which requests must originate from. Requests using this API key from other domains will not be allowed.
     *
     * Requirements:
     * + Contain only alphanumeric characters (A–Z, a–z, 0–9) or any symbols in this list `$\-._+!*`(),;/?:@=&amp;`
     * + May contain a percent (%) if followed by 2 hexadecimal digits (A-F, a-f, 0-9); this is used for URL encoding purposes.
     * + May contain wildcard characters question mark (?) and asterisk (*).Question mark (?) will replace any single character (including hexadecimal digits).Asterisk (*) will replace any multiple characters (including multiple hexadecimal digits).
     * + No spaces allowed. For example, `https://example.com`.
     */
    public val allowReferers: List<String>? = builder.allowReferers
    /**
     * A list of allowed resource ARNs that a API key bearer can perform actions on.
     * + The ARN must be the correct ARN for a map, place, or route ARN. You may include wildcards in the resource-id to match multiple resources of the same type.
     * + The resources must be in the same `partition`, `region`, and `account-id` as the key that is being created.
     * + Other than wildcards, you must include the full ARN, including the `arn`, `partition`, `service`, `region`, `account-id` and `resource-id` delimited by colons (:).
     * + No spaces allowed, even with wildcards. For example, `arn:aws:geo:region:<i>account-id</i>:map/ExampleMap*`.
     *
     * For more information about ARN format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val allowResources: List<String> = requireNotNull(builder.allowResources) { "A non-null value must be provided for allowResources" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ApiKeyRestrictions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApiKeyRestrictions(")
        append("allowActions=$allowActions,")
        append("allowReferers=$allowReferers,")
        append("allowResources=$allowResources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowActions.hashCode()
        result = 31 * result + (allowReferers?.hashCode() ?: 0)
        result = 31 * result + (allowResources.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApiKeyRestrictions

        if (allowActions != other.allowActions) return false
        if (allowReferers != other.allowReferers) return false
        if (allowResources != other.allowResources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ApiKeyRestrictions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of allowed actions that an API key resource grants permissions to perform. You must have at least one action for each type of resource. For example, if you have a place resource, you must include at least one place action.
         *
         * The following are valid values for the actions.
         * + **Map actions**
         *    + `geo:GetMap*` - Allows all actions needed for map rendering.
         * + **Place actions**
         *    + `geo:SearchPlaceIndexForText` - Allows geocoding.
         *    + `geo:SearchPlaceIndexForPosition` - Allows reverse geocoding.
         *    + `geo:SearchPlaceIndexForSuggestions` - Allows generating suggestions from text.
         *    + `GetPlace` - Allows finding a place by place ID.
         * + **Route actions**
         *    + `geo:CalculateRoute` - Allows point to point routing.
         *    + `geo:CalculateRouteMatrix` - Allows calculating a matrix of routes.
         *
         * You must use these strings exactly. For example, to provide access to map rendering, the only valid action is `geo:GetMap*` as an input to the list. `["geo:GetMap*"]` is valid but `["geo:GetMapTile"]` is not. Similarly, you cannot use `["geo:SearchPlaceIndexFor*"]` - you must list each of the Place actions separately.
         */
        public var allowActions: List<String>? = null
        /**
         * An optional list of allowed HTTP referers for which requests must originate from. Requests using this API key from other domains will not be allowed.
         *
         * Requirements:
         * + Contain only alphanumeric characters (A–Z, a–z, 0–9) or any symbols in this list `$\-._+!*`(),;/?:@=&amp;`
         * + May contain a percent (%) if followed by 2 hexadecimal digits (A-F, a-f, 0-9); this is used for URL encoding purposes.
         * + May contain wildcard characters question mark (?) and asterisk (*).Question mark (?) will replace any single character (including hexadecimal digits).Asterisk (*) will replace any multiple characters (including multiple hexadecimal digits).
         * + No spaces allowed. For example, `https://example.com`.
         */
        public var allowReferers: List<String>? = null
        /**
         * A list of allowed resource ARNs that a API key bearer can perform actions on.
         * + The ARN must be the correct ARN for a map, place, or route ARN. You may include wildcards in the resource-id to match multiple resources of the same type.
         * + The resources must be in the same `partition`, `region`, and `account-id` as the key that is being created.
         * + Other than wildcards, you must include the full ARN, including the `arn`, `partition`, `service`, `region`, `account-id` and `resource-id` delimited by colons (:).
         * + No spaces allowed, even with wildcards. For example, `arn:aws:geo:region:<i>account-id</i>:map/ExampleMap*`.
         *
         * For more information about ARN format, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var allowResources: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ApiKeyRestrictions) : this() {
            this.allowActions = x.allowActions
            this.allowReferers = x.allowReferers
            this.allowResources = x.allowResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ApiKeyRestrictions = ApiKeyRestrictions(this)

        internal fun correctErrors(): Builder {
            if (allowActions == null) allowActions = emptyList()
            if (allowResources == null) allowResources = emptyList()
            return this
        }
    }
}
