// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.serde

import aws.sdk.kotlin.services.location.model.DistanceUnit
import aws.sdk.kotlin.services.location.model.ForecastGeofenceEventsDeviceState
import aws.sdk.kotlin.services.location.model.ForecastGeofenceEventsRequest
import aws.sdk.kotlin.services.location.model.SpeedUnit
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ForecastGeofenceEventsOperationSerializer: HttpSerializer.NonStreaming<ForecastGeofenceEventsRequest> {
    override fun serialize(context: ExecutionContext, input: ForecastGeofenceEventsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.collectionName) { "collectionName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("geofencing"))
                add(PercentEncoding.Path.encode("v0"))
                add(PercentEncoding.Path.encode("collections"))
                add(PercentEncoding.SmithyLabel.encode(input.collectionName))
                add(PercentEncoding.Path.encode("forecast-geofence-events"))
            }
        }

        val payload = serializeForecastGeofenceEventsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeForecastGeofenceEventsOperationBody(context: ExecutionContext, input: ForecastGeofenceEventsRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEVICESTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeviceState"))
    val DISTANCEUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DistanceUnit"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SPEEDUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SpeedUnit"))
    val TIMEHORIZONMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("TimeHorizonMinutes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICESTATE_DESCRIPTOR)
        field(DISTANCEUNIT_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SPEEDUNIT_DESCRIPTOR)
        field(TIMEHORIZONMINUTES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.deviceState?.let { field(DEVICESTATE_DESCRIPTOR, it, ::serializeForecastGeofenceEventsDeviceStateDocument) }
        input.distanceUnit?.let { field(DISTANCEUNIT_DESCRIPTOR, it.value) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.speedUnit?.let { field(SPEEDUNIT_DESCRIPTOR, it.value) }
        input.timeHorizonMinutes?.let { field(TIMEHORIZONMINUTES_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
