// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

public class TagResourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource whose tags you want to update.
     * + Format example: `arn:aws:geo:region:account-id:resourcetype/ExampleResource`
     */
    public val resourceArn: kotlin.String = requireNotNull(builder.resourceArn) { "A non-null value must be provided for resourceArn" }
    /**
     * Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.
     *
     * Format: `"key" : "value"`
     *
     * Restrictions:
     * + Maximum 50 tags per resource.
     * + Each tag key must be unique and must have exactly one associated value.
     * + Maximum key length: 128 Unicode characters in UTF-8.
     * + Maximum value length: 256 Unicode characters in UTF-8.
     * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @
     * + Cannot use "aws:" as a prefix for a key.
     */
    public val tags: Map<String, String> = requireNotNull(builder.tags) { "A non-null value must be provided for tags" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.TagResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TagResourceRequest(")
        append("resourceArn=$resourceArn,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn.hashCode()
        result = 31 * result + (tags.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TagResourceRequest

        if (resourceArn != other.resourceArn) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.TagResourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource whose tags you want to update.
         * + Format example: `arn:aws:geo:region:account-id:resourcetype/ExampleResource`
         */
        public var resourceArn: kotlin.String? = null
        /**
         * Applies one or more tags to specific resource. A tag is a key-value pair that helps you manage, identify, search, and filter your resources.
         *
         * Format: `"key" : "value"`
         *
         * Restrictions:
         * + Maximum 50 tags per resource.
         * + Each tag key must be unique and must have exactly one associated value.
         * + Maximum key length: 128 Unicode characters in UTF-8.
         * + Maximum value length: 256 Unicode characters in UTF-8.
         * + Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : / @
         * + Cannot use "aws:" as a prefix for a key.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.TagResourceRequest) : this() {
            this.resourceArn = x.resourceArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.TagResourceRequest = TagResourceRequest(this)

        internal fun correctErrors(): Builder {
            if (resourceArn == null) resourceArn = ""
            if (tags == null) tags = emptyMap()
            return this
        }
    }
}
