// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A summary of the request sent by using `SearchPlaceIndexForPosition`.
 */
public class SearchPlaceIndexForPositionSummary private constructor(builder: Builder) {
    /**
     * The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:
     * + Esri
     * + Grab
     * + Here
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String = requireNotNull(builder.dataSource) { "A non-null value must be provided for dataSource" }
    /**
     * The preferred language used to return results. Matches the language in the request. The value is a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
     */
    public val language: kotlin.String? = builder.language
    /**
     * Contains the optional result count limit that is specified in the request.
     *
     * Default value: `50`
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The position specified in the request.
     */
    public val position: List<Double> = requireNotNull(builder.position) { "A non-null value must be provided for position" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchPlaceIndexForPositionSummary(")
        append("dataSource=$dataSource,")
        append("language=$language,")
        append("maxResults=$maxResults,")
        append("position=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSource.hashCode()
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (position.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchPlaceIndexForPositionSummary

        if (dataSource != other.dataSource) return false
        if (language != other.language) return false
        if (maxResults != other.maxResults) return false
        if (position != other.position) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The geospatial data provider attached to the place index resource specified in the request. Values can be one of the following:
         * + Esri
         * + Grab
         * + Here
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/previous/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * The preferred language used to return results. Matches the language in the request. The value is a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
         */
        public var language: kotlin.String? = null
        /**
         * Contains the optional result count limit that is specified in the request.
         *
         * Default value: `50`
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The position specified in the request.
         */
        public var position: List<Double>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionSummary) : this() {
            this.dataSource = x.dataSource
            this.language = x.language
            this.maxResults = x.maxResults
            this.position = x.position
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionSummary = SearchPlaceIndexForPositionSummary(this)

        internal fun correctErrors(): Builder {
            if (dataSource == null) dataSource = ""
            if (position == null) position = emptyList()
            return this
        }
    }
}
