// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeTrackerResponse private constructor(builder: Builder) {
    /**
     * The timestamp for when the tracker resource was created in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The optional description for the tracker resource.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * Whether `UPDATE` events from this tracker in EventBridge are enabled. If set to `true` these events will be sent to EventBridge.
     */
    public val eventBridgeEnabled: kotlin.Boolean? = builder.eventBridgeEnabled
    /**
     * Enables `GeospatialQueries` for a tracker that uses a [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
     *
     * This parameter is only used if you are using a KMS customer managed key.
     *
     * If you wish to encrypt your data using your own KMS customer managed key, then the Bounding Polygon Queries feature will be disabled by default. This is because by using this feature, a representation of your device positions will not be encrypted using the your KMS managed key. The exact device position, however; is still encrypted using your managed key.
     *
     * You can choose to opt-in to the Bounding Polygon Quseries feature. This is done by setting the `KmsKeyEnableGeospatialQueries` parameter to true when creating or updating a Tracker.
     */
    public val kmsKeyEnableGeospatialQueries: kotlin.Boolean? = builder.kmsKeyEnableGeospatialQueries
    /**
     * A key identifier for an [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) assigned to the Amazon Location resource.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The position filtering method of the tracker resource.
     */
    public val positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = builder.positionFiltering
    /**
     * The tags associated with the tracker resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:tracker/ExampleTracker`
     */
    public val trackerArn: kotlin.String = requireNotNull(builder.trackerArn) { "A non-null value must be provided for trackerArn" }
    /**
     * The name of the tracker resource.
     */
    public val trackerName: kotlin.String = requireNotNull(builder.trackerName) { "A non-null value must be provided for trackerName" }
    /**
     * The timestamp for when the tracker resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.DescribeTrackerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTrackerResponse(")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("description=$description,")
        append("eventBridgeEnabled=$eventBridgeEnabled,")
        append("kmsKeyEnableGeospatialQueries=$kmsKeyEnableGeospatialQueries,")
        append("kmsKeyId=$kmsKeyId,")
        append("positionFiltering=$positionFiltering,")
        append("tags=$tags,")
        append("trackerArn=$trackerArn,")
        append("trackerName=$trackerName,")
        append("updateTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (description.hashCode())
        result = 31 * result + (eventBridgeEnabled?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyEnableGeospatialQueries?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (positionFiltering?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trackerArn.hashCode())
        result = 31 * result + (trackerName.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTrackerResponse

        if (createTime != other.createTime) return false
        if (description != other.description) return false
        if (eventBridgeEnabled != other.eventBridgeEnabled) return false
        if (kmsKeyEnableGeospatialQueries != other.kmsKeyEnableGeospatialQueries) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (positionFiltering != other.positionFiltering) return false
        if (tags != other.tags) return false
        if (trackerArn != other.trackerArn) return false
        if (trackerName != other.trackerName) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.DescribeTrackerResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp for when the tracker resource was created in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional description for the tracker resource.
         */
        public var description: kotlin.String? = null
        /**
         * Whether `UPDATE` events from this tracker in EventBridge are enabled. If set to `true` these events will be sent to EventBridge.
         */
        public var eventBridgeEnabled: kotlin.Boolean? = null
        /**
         * Enables `GeospatialQueries` for a tracker that uses a [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html).
         *
         * This parameter is only used if you are using a KMS customer managed key.
         *
         * If you wish to encrypt your data using your own KMS customer managed key, then the Bounding Polygon Queries feature will be disabled by default. This is because by using this feature, a representation of your device positions will not be encrypted using the your KMS managed key. The exact device position, however; is still encrypted using your managed key.
         *
         * You can choose to opt-in to the Bounding Polygon Quseries feature. This is done by setting the `KmsKeyEnableGeospatialQueries` parameter to true when creating or updating a Tracker.
         */
        public var kmsKeyEnableGeospatialQueries: kotlin.Boolean? = null
        /**
         * A key identifier for an [Amazon Web Services KMS customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html) assigned to the Amazon Location resource.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The position filtering method of the tracker resource.
         */
        public var positionFiltering: aws.sdk.kotlin.services.location.model.PositionFiltering? = null
        /**
         * The tags associated with the tracker resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) for the tracker resource. Used when you need to specify a resource across all Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:tracker/ExampleTracker`
         */
        public var trackerArn: kotlin.String? = null
        /**
         * The name of the tracker resource.
         */
        public var trackerName: kotlin.String? = null
        /**
         * The timestamp for when the tracker resource was last updated in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.DescribeTrackerResponse) : this() {
            this.createTime = x.createTime
            this.description = x.description
            this.eventBridgeEnabled = x.eventBridgeEnabled
            this.kmsKeyEnableGeospatialQueries = x.kmsKeyEnableGeospatialQueries
            this.kmsKeyId = x.kmsKeyId
            this.positionFiltering = x.positionFiltering
            this.tags = x.tags
            this.trackerArn = x.trackerArn
            this.trackerName = x.trackerName
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.DescribeTrackerResponse = DescribeTrackerResponse(this)

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (trackerArn == null) trackerArn = ""
            if (trackerName == null) trackerName = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
