// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateKeyResponse private constructor(builder: Builder) {
    /**
     * The timestamp for when the API key resource was created in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The key value/string of an API key. This value is used when making API calls to authorize the call. For example, see [GetMapGlyphs](https://docs.aws.amazon.com/location/previous/APIReference/API_GetMapGlyphs.html).
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The Amazon Resource Name (ARN) for the API key resource. Used when you need to specify a resource across all Amazon Web Services.
     * + Format example: `arn:aws:geo:region:account-id:key/ExampleKey`
     */
    public val keyArn: kotlin.String = requireNotNull(builder.keyArn) { "A non-null value must be provided for keyArn" }
    /**
     * The name of the API key resource.
     */
    public val keyName: kotlin.String = requireNotNull(builder.keyName) { "A non-null value must be provided for keyName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.CreateKeyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateKeyResponse(")
        append("createTime=*** Sensitive Data Redacted ***,")
        append("key=*** Sensitive Data Redacted ***,")
        append("keyArn=$keyArn,")
        append("keyName=$keyName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (key.hashCode())
        result = 31 * result + (keyArn.hashCode())
        result = 31 * result + (keyName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateKeyResponse

        if (createTime != other.createTime) return false
        if (key != other.key) return false
        if (keyArn != other.keyArn) return false
        if (keyName != other.keyName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.CreateKeyResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The timestamp for when the API key resource was created in [ ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The key value/string of an API key. This value is used when making API calls to authorize the call. For example, see [GetMapGlyphs](https://docs.aws.amazon.com/location/previous/APIReference/API_GetMapGlyphs.html).
         */
        public var key: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the API key resource. Used when you need to specify a resource across all Amazon Web Services.
         * + Format example: `arn:aws:geo:region:account-id:key/ExampleKey`
         */
        public var keyArn: kotlin.String? = null
        /**
         * The name of the API key resource.
         */
        public var keyName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.CreateKeyResponse) : this() {
            this.createTime = x.createTime
            this.key = x.key
            this.keyArn = x.keyArn
            this.keyName = x.keyName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.CreateKeyResponse = CreateKeyResponse(this)

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (key == null) key = ""
            if (keyArn == null) keyArn = ""
            if (keyName == null) keyName = ""
            return this
        }
    }
}
