// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains error details for each device that failed to evaluate its position against the geofences in a given geofence collection.
 */
public class BatchEvaluateGeofencesError private constructor(builder: Builder) {
    /**
     * The device associated with the position evaluation error.
     */
    public val deviceId: kotlin.String = requireNotNull(builder.deviceId) { "A non-null value must be provided for deviceId" }
    /**
     * Contains details associated to the batch error.
     */
    public val error: aws.sdk.kotlin.services.location.model.BatchItemError? = builder.error
    /**
     * Specifies a timestamp for when the error occurred in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
     */
    public val sampleTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.sampleTime) { "A non-null value must be provided for sampleTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.BatchEvaluateGeofencesError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchEvaluateGeofencesError(")
        append("deviceId=$deviceId,")
        append("error=$error,")
        append("sampleTime=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceId.hashCode()
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (sampleTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchEvaluateGeofencesError

        if (deviceId != other.deviceId) return false
        if (error != other.error) return false
        if (sampleTime != other.sampleTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.BatchEvaluateGeofencesError = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The device associated with the position evaluation error.
         */
        public var deviceId: kotlin.String? = null
        /**
         * Contains details associated to the batch error.
         */
        public var error: aws.sdk.kotlin.services.location.model.BatchItemError? = null
        /**
         * Specifies a timestamp for when the error occurred in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`
         */
        public var sampleTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.BatchEvaluateGeofencesError) : this() {
            this.deviceId = x.deviceId
            this.error = x.error
            this.sampleTime = x.sampleTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.BatchEvaluateGeofencesError = BatchEvaluateGeofencesError(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.BatchItemError] inside the given [block]
         */
        public fun error(block: aws.sdk.kotlin.services.location.model.BatchItemError.Builder.() -> kotlin.Unit) {
            this.error = aws.sdk.kotlin.services.location.model.BatchItemError.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (deviceId == null) deviceId = ""
            if (sampleTime == null) sampleTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
