// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.location.auth.DefaultLocationAuthSchemeProvider
import aws.sdk.kotlin.services.location.auth.LocationAuthSchemeProvider
import aws.sdk.kotlin.services.location.endpoints.DefaultLocationEndpointProvider
import aws.sdk.kotlin.services.location.endpoints.LocationEndpointParameters
import aws.sdk.kotlin.services.location.endpoints.LocationEndpointProvider
import aws.sdk.kotlin.services.location.model.AssociateTrackerConsumerRequest
import aws.sdk.kotlin.services.location.model.AssociateTrackerConsumerResponse
import aws.sdk.kotlin.services.location.model.BatchDeleteDevicePositionHistoryRequest
import aws.sdk.kotlin.services.location.model.BatchDeleteDevicePositionHistoryResponse
import aws.sdk.kotlin.services.location.model.BatchDeleteGeofenceRequest
import aws.sdk.kotlin.services.location.model.BatchDeleteGeofenceResponse
import aws.sdk.kotlin.services.location.model.BatchEvaluateGeofencesRequest
import aws.sdk.kotlin.services.location.model.BatchEvaluateGeofencesResponse
import aws.sdk.kotlin.services.location.model.BatchGetDevicePositionRequest
import aws.sdk.kotlin.services.location.model.BatchGetDevicePositionResponse
import aws.sdk.kotlin.services.location.model.BatchPutGeofenceRequest
import aws.sdk.kotlin.services.location.model.BatchPutGeofenceResponse
import aws.sdk.kotlin.services.location.model.BatchUpdateDevicePositionRequest
import aws.sdk.kotlin.services.location.model.BatchUpdateDevicePositionResponse
import aws.sdk.kotlin.services.location.model.CalculateRouteMatrixRequest
import aws.sdk.kotlin.services.location.model.CalculateRouteMatrixResponse
import aws.sdk.kotlin.services.location.model.CalculateRouteRequest
import aws.sdk.kotlin.services.location.model.CalculateRouteResponse
import aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionRequest
import aws.sdk.kotlin.services.location.model.CreateGeofenceCollectionResponse
import aws.sdk.kotlin.services.location.model.CreateKeyRequest
import aws.sdk.kotlin.services.location.model.CreateKeyResponse
import aws.sdk.kotlin.services.location.model.CreateMapRequest
import aws.sdk.kotlin.services.location.model.CreateMapResponse
import aws.sdk.kotlin.services.location.model.CreatePlaceIndexRequest
import aws.sdk.kotlin.services.location.model.CreatePlaceIndexResponse
import aws.sdk.kotlin.services.location.model.CreateRouteCalculatorRequest
import aws.sdk.kotlin.services.location.model.CreateRouteCalculatorResponse
import aws.sdk.kotlin.services.location.model.CreateTrackerRequest
import aws.sdk.kotlin.services.location.model.CreateTrackerResponse
import aws.sdk.kotlin.services.location.model.DeleteGeofenceCollectionRequest
import aws.sdk.kotlin.services.location.model.DeleteGeofenceCollectionResponse
import aws.sdk.kotlin.services.location.model.DeleteKeyRequest
import aws.sdk.kotlin.services.location.model.DeleteKeyResponse
import aws.sdk.kotlin.services.location.model.DeleteMapRequest
import aws.sdk.kotlin.services.location.model.DeleteMapResponse
import aws.sdk.kotlin.services.location.model.DeletePlaceIndexRequest
import aws.sdk.kotlin.services.location.model.DeletePlaceIndexResponse
import aws.sdk.kotlin.services.location.model.DeleteRouteCalculatorRequest
import aws.sdk.kotlin.services.location.model.DeleteRouteCalculatorResponse
import aws.sdk.kotlin.services.location.model.DeleteTrackerRequest
import aws.sdk.kotlin.services.location.model.DeleteTrackerResponse
import aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionRequest
import aws.sdk.kotlin.services.location.model.DescribeGeofenceCollectionResponse
import aws.sdk.kotlin.services.location.model.DescribeKeyRequest
import aws.sdk.kotlin.services.location.model.DescribeKeyResponse
import aws.sdk.kotlin.services.location.model.DescribeMapRequest
import aws.sdk.kotlin.services.location.model.DescribeMapResponse
import aws.sdk.kotlin.services.location.model.DescribePlaceIndexRequest
import aws.sdk.kotlin.services.location.model.DescribePlaceIndexResponse
import aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorRequest
import aws.sdk.kotlin.services.location.model.DescribeRouteCalculatorResponse
import aws.sdk.kotlin.services.location.model.DescribeTrackerRequest
import aws.sdk.kotlin.services.location.model.DescribeTrackerResponse
import aws.sdk.kotlin.services.location.model.DisassociateTrackerConsumerRequest
import aws.sdk.kotlin.services.location.model.DisassociateTrackerConsumerResponse
import aws.sdk.kotlin.services.location.model.ForecastGeofenceEventsRequest
import aws.sdk.kotlin.services.location.model.ForecastGeofenceEventsResponse
import aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryRequest
import aws.sdk.kotlin.services.location.model.GetDevicePositionHistoryResponse
import aws.sdk.kotlin.services.location.model.GetDevicePositionRequest
import aws.sdk.kotlin.services.location.model.GetDevicePositionResponse
import aws.sdk.kotlin.services.location.model.GetGeofenceRequest
import aws.sdk.kotlin.services.location.model.GetGeofenceResponse
import aws.sdk.kotlin.services.location.model.GetMapGlyphsRequest
import aws.sdk.kotlin.services.location.model.GetMapGlyphsResponse
import aws.sdk.kotlin.services.location.model.GetMapSpritesRequest
import aws.sdk.kotlin.services.location.model.GetMapSpritesResponse
import aws.sdk.kotlin.services.location.model.GetMapStyleDescriptorRequest
import aws.sdk.kotlin.services.location.model.GetMapStyleDescriptorResponse
import aws.sdk.kotlin.services.location.model.GetMapTileRequest
import aws.sdk.kotlin.services.location.model.GetMapTileResponse
import aws.sdk.kotlin.services.location.model.GetPlaceRequest
import aws.sdk.kotlin.services.location.model.GetPlaceResponse
import aws.sdk.kotlin.services.location.model.ListDevicePositionsRequest
import aws.sdk.kotlin.services.location.model.ListDevicePositionsResponse
import aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsRequest
import aws.sdk.kotlin.services.location.model.ListGeofenceCollectionsResponse
import aws.sdk.kotlin.services.location.model.ListGeofencesRequest
import aws.sdk.kotlin.services.location.model.ListGeofencesResponse
import aws.sdk.kotlin.services.location.model.ListKeysRequest
import aws.sdk.kotlin.services.location.model.ListKeysResponse
import aws.sdk.kotlin.services.location.model.ListMapsRequest
import aws.sdk.kotlin.services.location.model.ListMapsResponse
import aws.sdk.kotlin.services.location.model.ListPlaceIndexesRequest
import aws.sdk.kotlin.services.location.model.ListPlaceIndexesResponse
import aws.sdk.kotlin.services.location.model.ListRouteCalculatorsRequest
import aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponse
import aws.sdk.kotlin.services.location.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.location.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.location.model.ListTrackerConsumersRequest
import aws.sdk.kotlin.services.location.model.ListTrackerConsumersResponse
import aws.sdk.kotlin.services.location.model.ListTrackersRequest
import aws.sdk.kotlin.services.location.model.ListTrackersResponse
import aws.sdk.kotlin.services.location.model.PutGeofenceRequest
import aws.sdk.kotlin.services.location.model.PutGeofenceResponse
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionRequest
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForPositionResponse
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsRequest
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsResponse
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextRequest
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextResponse
import aws.sdk.kotlin.services.location.model.TagResourceRequest
import aws.sdk.kotlin.services.location.model.TagResourceResponse
import aws.sdk.kotlin.services.location.model.UntagResourceRequest
import aws.sdk.kotlin.services.location.model.UntagResourceResponse
import aws.sdk.kotlin.services.location.model.UpdateGeofenceCollectionRequest
import aws.sdk.kotlin.services.location.model.UpdateGeofenceCollectionResponse
import aws.sdk.kotlin.services.location.model.UpdateKeyRequest
import aws.sdk.kotlin.services.location.model.UpdateKeyResponse
import aws.sdk.kotlin.services.location.model.UpdateMapRequest
import aws.sdk.kotlin.services.location.model.UpdateMapResponse
import aws.sdk.kotlin.services.location.model.UpdatePlaceIndexRequest
import aws.sdk.kotlin.services.location.model.UpdatePlaceIndexResponse
import aws.sdk.kotlin.services.location.model.UpdateRouteCalculatorRequest
import aws.sdk.kotlin.services.location.model.UpdateRouteCalculatorResponse
import aws.sdk.kotlin.services.location.model.UpdateTrackerRequest
import aws.sdk.kotlin.services.location.model.UpdateTrackerResponse
import aws.sdk.kotlin.services.location.model.VerifyDevicePositionRequest
import aws.sdk.kotlin.services.location.model.VerifyDevicePositionResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Location"
public const val SdkVersion: String = "1.5.11"
public const val ServiceApiVersion: String = "2020-11-19"

/**
 * "Suite of geospatial services including Maps, Places, Routes, Tracking, and Geofencing"
 */
public interface LocationClient : SdkClient {
    /**
     * LocationClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, LocationClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Location",
                "LOCATION",
                "location",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, LocationClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): LocationClient = DefaultLocationClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: LocationEndpointProvider = builder.endpointProvider ?: DefaultLocationEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: LocationAuthSchemeProvider = builder.authSchemeProvider ?: DefaultLocationAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Location"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: LocationEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: LocationAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection.
     *
     * You can associate up to five geofence collections to each tracker resource.
     *
     * Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.
     */
    public suspend fun associateTrackerConsumer(input: AssociateTrackerConsumerRequest): AssociateTrackerConsumerResponse

    /**
     * Deletes the position history of one or more devices from a tracker resource.
     */
    public suspend fun batchDeleteDevicePositionHistory(input: BatchDeleteDevicePositionHistoryRequest): BatchDeleteDevicePositionHistoryResponse

    /**
     * Deletes a batch of geofences from a geofence collection.
     *
     * This operation deletes the resource permanently.
     */
    public suspend fun batchDeleteGeofence(input: BatchDeleteGeofenceRequest): BatchDeleteGeofenceResponse

    /**
     * Evaluates device positions against the geofence geometries from a given geofence collection.
     *
     * This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation determines if the device has entered or exited a geofenced area, and then publishes one of the following events to Amazon EventBridge:
     * + `ENTER` if Amazon Location determines that the tracked device has entered a geofenced area.
     * + `EXIT` if Amazon Location determines that the tracked device has exited a geofenced area.
     *
     * The last geofence that a device was observed within is tracked for 30 days after the most recent device position update.
     *
     * Geofence evaluation uses the given device position. It does not account for the optional `Accuracy` of a `DevicePositionUpdate`.
     *
     * The `DeviceID` is used as a string to represent the device. You do not need to have a `Tracker` associated with the `DeviceID`.
     */
    public suspend fun batchEvaluateGeofences(input: BatchEvaluateGeofencesRequest): BatchEvaluateGeofencesResponse

    /**
     * Lists the latest device positions for requested devices.
     */
    public suspend fun batchGetDevicePosition(input: BatchGetDevicePositionRequest): BatchGetDevicePositionResponse

    /**
     * A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
     */
    public suspend fun batchPutGeofence(input: BatchPutGeofenceRequest): BatchPutGeofenceResponse

    /**
     * Uploads position update data for one or more devices to a tracker resource (up to 10 devices per batch). Amazon Location uses the data when it reports the last known device position and position history. Amazon Location retains location data for 30 days.
     *
     * Position updates are handled based on the `PositionFiltering` property of the tracker. When `PositionFiltering` is set to `TimeBased`, updates are evaluated against linked geofence collections, and location data is stored at a maximum of one position per 30 second interval. If your update frequency is more often than every 30 seconds, only one update per 30 seconds is stored for each unique device ID.
     *
     * When `PositionFiltering` is set to `DistanceBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than 30 m (98.4 ft).
     *
     * When `PositionFiltering` is set to `AccuracyBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than the measured accuracy. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is neither stored or evaluated if the device has moved less than 15 m. If `PositionFiltering` is set to `AccuracyBased` filtering, Amazon Location uses the default value `{ "Horizontal": 0}` when accuracy is not provided on a `DevicePositionUpdate`.
     */
    public suspend fun batchUpdateDevicePosition(input: BatchUpdateDevicePositionRequest): BatchUpdateDevicePositionResponse

    /**
     * [Calculates a route](https://docs.aws.amazon.com/location/previous/developerguide/calculate-route.html) given the following required parameters: `DeparturePosition` and `DestinationPosition`. Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
     *
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating the route.
     *
     * Additional options include:
     * + [Specifying a departure time](https://docs.aws.amazon.com/location/previous/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates a route based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
     * + [Specifying a travel mode](https://docs.aws.amazon.com/location/previous/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.If you specify `walking` for the travel mode and your data provider is Esri, the start and destination must be within 40km.
     */
    public suspend fun calculateRoute(input: CalculateRouteRequest): CalculateRouteResponse

    /**
     * [ Calculates a route matrix](https://docs.aws.amazon.com/location/previous/developerguide/calculate-route-matrix.html) given the following required parameters: `DeparturePositions` and `DestinationPositions`. `CalculateRouteMatrix` calculates routes and returns the travel time and travel distance from each departure position to each destination position in the request. For example, given departure positions A and B, and destination positions X and Y, `CalculateRouteMatrix` will return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of results returned (and routes calculated) will be the number of `DeparturePositions` times the number of `DestinationPositions`.
     *
     * Your account is charged for each route calculated, not the number of requests.
     *
     * Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
     *
     * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating routes.
     *
     * Additional options include:
     * + [ Specifying a departure time](https://docs.aws.amazon.com/location/previous/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates routes based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
     * + [Specifying a travel mode](https://docs.aws.amazon.com/location/previous/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.
     */
    public suspend fun calculateRouteMatrix(input: CalculateRouteMatrixRequest): CalculateRouteMatrixResponse

    /**
     * Creates a geofence collection, which manages and stores geofences.
     */
    public suspend fun createGeofenceCollection(input: CreateGeofenceCollectionRequest): CreateGeofenceCollectionResponse

    /**
     * Creates an API key resource in your Amazon Web Services account, which lets you grant actions for Amazon Location resources to the API key bearer.
     *
     * For more information, see [Using API keys](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html).
     */
    public suspend fun createKey(input: CreateKeyRequest): CreateKeyResponse

    /**
     * Creates a map resource in your Amazon Web Services account, which provides map tiles of different styles sourced from global location data providers.
     *
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you must not use Esri as your geolocation provider. See section 82 of the [Amazon Web Services service terms](http://aws.amazon.com/service-terms) for more details.
     */
    public suspend fun createMap(input: CreateMapRequest): CreateMapResponse

    /**
     * Creates a place index resource in your Amazon Web Services account. Use a place index resource to geocode addresses and other text queries by using the `SearchPlaceIndexForText` operation, and reverse geocode coordinates by using the `SearchPlaceIndexForPosition` operation, and enable autosuggestions by using the `SearchPlaceIndexForSuggestions` operation.
     *
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you must not use Esri as your geolocation provider. See section 82 of the [Amazon Web Services service terms](http://aws.amazon.com/service-terms) for more details.
     */
    public suspend fun createPlaceIndex(input: CreatePlaceIndexRequest): CreatePlaceIndexResponse

    /**
     * Creates a route calculator resource in your Amazon Web Services account.
     *
     * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.
     *
     * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you must not use Esri as your geolocation provider. See section 82 of the [Amazon Web Services service terms](http://aws.amazon.com/service-terms) for more details.
     */
    public suspend fun createRouteCalculator(input: CreateRouteCalculatorRequest): CreateRouteCalculatorResponse

    /**
     * Creates a tracker resource in your Amazon Web Services account, which lets you retrieve current and historical location of devices.
     */
    public suspend fun createTracker(input: CreateTrackerRequest): CreateTrackerResponse

    /**
     * Deletes a geofence collection from your Amazon Web Services account.
     *
     * This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource, the devices will no longer be monitored.
     */
    public suspend fun deleteGeofenceCollection(input: DeleteGeofenceCollectionRequest): DeleteGeofenceCollectionResponse

    /**
     * Deletes the specified API key. The API key must have been deactivated more than 90 days previously.
     */
    public suspend fun deleteKey(input: DeleteKeyRequest): DeleteKeyResponse

    /**
     * Deletes a map resource from your Amazon Web Services account.
     *
     * This operation deletes the resource permanently. If the map is being used in an application, the map may not render.
     */
    public suspend fun deleteMap(input: DeleteMapRequest): DeleteMapResponse

    /**
     * Deletes a place index resource from your Amazon Web Services account.
     *
     * This operation deletes the resource permanently.
     */
    public suspend fun deletePlaceIndex(input: DeletePlaceIndexRequest): DeletePlaceIndexResponse

    /**
     * Deletes a route calculator resource from your Amazon Web Services account.
     *
     * This operation deletes the resource permanently.
     */
    public suspend fun deleteRouteCalculator(input: DeleteRouteCalculatorRequest): DeleteRouteCalculatorResponse

    /**
     * Deletes a tracker resource from your Amazon Web Services account.
     *
     * This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error. Make sure that the target resource isn't a dependency for your applications.
     */
    public suspend fun deleteTracker(input: DeleteTrackerRequest): DeleteTrackerResponse

    /**
     * Retrieves the geofence collection details.
     */
    public suspend fun describeGeofenceCollection(input: DescribeGeofenceCollectionRequest): DescribeGeofenceCollectionResponse

    /**
     * Retrieves the API key resource details.
     */
    public suspend fun describeKey(input: DescribeKeyRequest): DescribeKeyResponse

    /**
     * Retrieves the map resource details.
     */
    public suspend fun describeMap(input: DescribeMapRequest): DescribeMapResponse

    /**
     * Retrieves the place index resource details.
     */
    public suspend fun describePlaceIndex(input: DescribePlaceIndexRequest): DescribePlaceIndexResponse

    /**
     * Retrieves the route calculator resource details.
     */
    public suspend fun describeRouteCalculator(input: DescribeRouteCalculatorRequest): DescribeRouteCalculatorResponse

    /**
     * Retrieves the tracker resource details.
     */
    public suspend fun describeTracker(input: DescribeTrackerRequest): DescribeTrackerResponse

    /**
     * Removes the association between a tracker resource and a geofence collection.
     *
     * Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be automatically evaluated against geofences.
     */
    public suspend fun disassociateTrackerConsumer(input: DisassociateTrackerConsumerRequest): DisassociateTrackerConsumerResponse

    /**
     * This action forecasts future geofence events that are likely to occur within a specified time horizon if a device continues moving at its current speed. Each forecasted event is associated with a geofence from a provided geofence collection. A forecast event can have one of the following states:
     *
     * `ENTER`: The device position is outside the referenced geofence, but the device may cross into the geofence during the forecasting time horizon if it maintains its current speed.
     *
     * `EXIT`: The device position is inside the referenced geofence, but the device may leave the geofence during the forecasted time horizon if the device maintains it's current speed.
     *
     * `IDLE`:The device is inside the geofence, and it will remain inside the geofence through the end of the time horizon if the device maintains it's current speed.
     *
     * Heading direction is not considered in the current version. The API takes a conservative approach and includes events that can occur for any heading.
     */
    public suspend fun forecastGeofenceEvents(input: ForecastGeofenceEventsRequest): ForecastGeofenceEventsResponse

    /**
     * Retrieves a device's most recent position according to its sample time.
     *
     * Device positions are deleted after 30 days.
     */
    public suspend fun getDevicePosition(input: GetDevicePositionRequest): GetDevicePositionResponse

    /**
     * Retrieves the device position history from a tracker resource within a specified range of time.
     *
     * Device positions are deleted after 30 days.
     */
    public suspend fun getDevicePositionHistory(input: GetDevicePositionHistoryRequest): GetDevicePositionHistoryResponse

    /**
     * Retrieves the geofence details from a geofence collection.
     *
     * The returned geometry will always match the geometry format used when the geofence was created.
     */
    public suspend fun getGeofence(input: GetGeofenceRequest): GetGeofenceResponse

    /**
     * Retrieves glyphs used to display labels on a map.
     */
    public suspend fun getMapGlyphs(input: GetMapGlyphsRequest): GetMapGlyphsResponse

    /**
     * Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON document describing the offsets of individual icons that will be displayed on a rendered map.
     */
    public suspend fun getMapSprites(input: GetMapSpritesRequest): GetMapSpritesResponse

    /**
     * Retrieves the map style descriptor from a map resource.
     *
     * The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display, what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style Specification.
     */
    public suspend fun getMapStyleDescriptor(input: GetMapStyleDescriptorRequest): GetMapStyleDescriptorResponse

    /**
     * Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
     *
     * The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions, so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).
     */
    public suspend fun getMapTile(input: GetMapTileRequest): GetMapTileResponse

    /**
     * Finds a place by its unique ID. A `PlaceId` is returned by other search operations.
     *
     * A PlaceId is valid only if all of the following are the same in the original search request and the call to `GetPlace`.
     * + Customer Amazon Web Services account
     * + Amazon Web Services Region
     * + Data provider specified in the place index resource
     * If your Place index resource is configured with Grab as your geolocation provider and Storage as Intended use, the GetPlace operation is unavailable. For more information, see [AWS service terms](http://aws.amazon.com/service-terms).
     */
    public suspend fun getPlace(input: GetPlaceRequest): GetPlaceResponse

    /**
     * A batch request to retrieve all device positions.
     */
    public suspend fun listDevicePositions(input: ListDevicePositionsRequest): ListDevicePositionsResponse

    /**
     * Lists geofence collections in your Amazon Web Services account.
     */
    public suspend fun listGeofenceCollections(input: ListGeofenceCollectionsRequest = ListGeofenceCollectionsRequest { }): ListGeofenceCollectionsResponse

    /**
     * Lists geofences stored in a given geofence collection.
     */
    public suspend fun listGeofences(input: ListGeofencesRequest): ListGeofencesResponse

    /**
     * Lists API key resources in your Amazon Web Services account.
     */
    public suspend fun listKeys(input: ListKeysRequest = ListKeysRequest { }): ListKeysResponse

    /**
     * Lists map resources in your Amazon Web Services account.
     */
    public suspend fun listMaps(input: ListMapsRequest = ListMapsRequest { }): ListMapsResponse

    /**
     * Lists place index resources in your Amazon Web Services account.
     */
    public suspend fun listPlaceIndexes(input: ListPlaceIndexesRequest = ListPlaceIndexesRequest { }): ListPlaceIndexesResponse

    /**
     * Lists route calculator resources in your Amazon Web Services account.
     */
    public suspend fun listRouteCalculators(input: ListRouteCalculatorsRequest = ListRouteCalculatorsRequest { }): ListRouteCalculatorsResponse

    /**
     * Returns a list of tags that are applied to the specified Amazon Location resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists geofence collections currently associated to the given tracker resource.
     */
    public suspend fun listTrackerConsumers(input: ListTrackerConsumersRequest): ListTrackerConsumersResponse

    /**
     * Lists tracker resources in your Amazon Web Services account.
     */
    public suspend fun listTrackers(input: ListTrackersRequest = ListTrackersRequest { }): ListTrackersResponse

    /**
     * Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
     */
    public suspend fun putGeofence(input: PutGeofenceRequest): PutGeofenceResponse

    /**
     * Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of interest near a given position.
     */
    public suspend fun searchPlaceIndexForPosition(input: SearchPlaceIndexForPositionRequest): SearchPlaceIndexForPositionResponse

    /**
     * Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This operation is also known as autocomplete, autosuggest, or fuzzy matching.
     *
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
     *
     * You can search for suggested place names near a specified position by using `BiasPosition`, or filter results within a bounding box by using `FilterBBox`. These parameters are mutually exclusive; using both `BiasPosition` and `FilterBBox` in the same command returns an error.
     */
    public suspend fun searchPlaceIndexForSuggestions(input: SearchPlaceIndexForSuggestionsRequest): SearchPlaceIndexForSuggestionsResponse

    /**
     * Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of interest.
     *
     * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
     *
     * You can search for places near a given position using `BiasPosition`, or filter results within a bounding box using `FilterBBox`. Providing both parameters simultaneously returns an error.
     *
     * Search results are returned in order of highest to lowest relevance.
     */
    public suspend fun searchPlaceIndexForText(input: SearchPlaceIndexForTextRequest): SearchPlaceIndexForTextResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.
     *
     * You can use the `TagResource` operation with an Amazon Location Service resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the resource. If you specify a tag key that's already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate up to 50 tags with a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from the specified Amazon Location resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified properties of a given geofence collection.
     */
    public suspend fun updateGeofenceCollection(input: UpdateGeofenceCollectionRequest): UpdateGeofenceCollectionResponse

    /**
     * Updates the specified properties of a given API key resource.
     */
    public suspend fun updateKey(input: UpdateKeyRequest): UpdateKeyResponse

    /**
     * Updates the specified properties of a given map resource.
     */
    public suspend fun updateMap(input: UpdateMapRequest): UpdateMapResponse

    /**
     * Updates the specified properties of a given place index resource.
     */
    public suspend fun updatePlaceIndex(input: UpdatePlaceIndexRequest): UpdatePlaceIndexResponse

    /**
     * Updates the specified properties for a given route calculator resource.
     */
    public suspend fun updateRouteCalculator(input: UpdateRouteCalculatorRequest): UpdateRouteCalculatorResponse

    /**
     * Updates the specified properties of a given tracker resource.
     */
    public suspend fun updateTracker(input: UpdateTrackerRequest): UpdateTrackerResponse

    /**
     * Verifies the integrity of the device's position by determining if it was reported behind a proxy, and by comparing it to an inferred position estimated based on the device's state.
     *
     * The Location Integrity SDK provides enhanced features related to device verification, and it is available for use by request. To get access to the SDK, contact [Sales Support](https://aws.amazon.com/contact-us/sales-support/?pg=locationprice&cta=herobtn).
     */
    public suspend fun verifyDevicePosition(input: VerifyDevicePositionRequest): VerifyDevicePositionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun LocationClient.withConfig(block: LocationClient.Config.Builder.() -> Unit): LocationClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultLocationClient(newConfig)
}

/**
 * Creates an association between a geofence collection and a tracker resource. This allows the tracker resource to communicate location data to the linked geofence collection.
 *
 * You can associate up to five geofence collections to each tracker resource.
 *
 * Currently not supported — Cross-account configurations, such as creating associations between a tracker resource in one account and a geofence collection in another account.
 */
public suspend inline fun LocationClient.associateTrackerConsumer(crossinline block: AssociateTrackerConsumerRequest.Builder.() -> Unit): AssociateTrackerConsumerResponse = associateTrackerConsumer(AssociateTrackerConsumerRequest.Builder().apply(block).build())

/**
 * Deletes the position history of one or more devices from a tracker resource.
 */
public suspend inline fun LocationClient.batchDeleteDevicePositionHistory(crossinline block: BatchDeleteDevicePositionHistoryRequest.Builder.() -> Unit): BatchDeleteDevicePositionHistoryResponse = batchDeleteDevicePositionHistory(BatchDeleteDevicePositionHistoryRequest.Builder().apply(block).build())

/**
 * Deletes a batch of geofences from a geofence collection.
 *
 * This operation deletes the resource permanently.
 */
public suspend inline fun LocationClient.batchDeleteGeofence(crossinline block: BatchDeleteGeofenceRequest.Builder.() -> Unit): BatchDeleteGeofenceResponse = batchDeleteGeofence(BatchDeleteGeofenceRequest.Builder().apply(block).build())

/**
 * Evaluates device positions against the geofence geometries from a given geofence collection.
 *
 * This operation always returns an empty response because geofences are asynchronously evaluated. The evaluation determines if the device has entered or exited a geofenced area, and then publishes one of the following events to Amazon EventBridge:
 * + `ENTER` if Amazon Location determines that the tracked device has entered a geofenced area.
 * + `EXIT` if Amazon Location determines that the tracked device has exited a geofenced area.
 *
 * The last geofence that a device was observed within is tracked for 30 days after the most recent device position update.
 *
 * Geofence evaluation uses the given device position. It does not account for the optional `Accuracy` of a `DevicePositionUpdate`.
 *
 * The `DeviceID` is used as a string to represent the device. You do not need to have a `Tracker` associated with the `DeviceID`.
 */
public suspend inline fun LocationClient.batchEvaluateGeofences(crossinline block: BatchEvaluateGeofencesRequest.Builder.() -> Unit): BatchEvaluateGeofencesResponse = batchEvaluateGeofences(BatchEvaluateGeofencesRequest.Builder().apply(block).build())

/**
 * Lists the latest device positions for requested devices.
 */
public suspend inline fun LocationClient.batchGetDevicePosition(crossinline block: BatchGetDevicePositionRequest.Builder.() -> Unit): BatchGetDevicePositionResponse = batchGetDevicePosition(BatchGetDevicePositionRequest.Builder().apply(block).build())

/**
 * A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
 */
public suspend inline fun LocationClient.batchPutGeofence(crossinline block: BatchPutGeofenceRequest.Builder.() -> Unit): BatchPutGeofenceResponse = batchPutGeofence(BatchPutGeofenceRequest.Builder().apply(block).build())

/**
 * Uploads position update data for one or more devices to a tracker resource (up to 10 devices per batch). Amazon Location uses the data when it reports the last known device position and position history. Amazon Location retains location data for 30 days.
 *
 * Position updates are handled based on the `PositionFiltering` property of the tracker. When `PositionFiltering` is set to `TimeBased`, updates are evaluated against linked geofence collections, and location data is stored at a maximum of one position per 30 second interval. If your update frequency is more often than every 30 seconds, only one update per 30 seconds is stored for each unique device ID.
 *
 * When `PositionFiltering` is set to `DistanceBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than 30 m (98.4 ft).
 *
 * When `PositionFiltering` is set to `AccuracyBased` filtering, location data is stored and evaluated against linked geofence collections only if the device has moved more than the measured accuracy. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is neither stored or evaluated if the device has moved less than 15 m. If `PositionFiltering` is set to `AccuracyBased` filtering, Amazon Location uses the default value `{ "Horizontal": 0}` when accuracy is not provided on a `DevicePositionUpdate`.
 */
public suspend inline fun LocationClient.batchUpdateDevicePosition(crossinline block: BatchUpdateDevicePositionRequest.Builder.() -> Unit): BatchUpdateDevicePositionResponse = batchUpdateDevicePosition(BatchUpdateDevicePositionRequest.Builder().apply(block).build())

/**
 * [Calculates a route](https://docs.aws.amazon.com/location/previous/developerguide/calculate-route.html) given the following required parameters: `DeparturePosition` and `DestinationPosition`. Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
 *
 * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating the route.
 *
 * Additional options include:
 * + [Specifying a departure time](https://docs.aws.amazon.com/location/previous/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates a route based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
 * + [Specifying a travel mode](https://docs.aws.amazon.com/location/previous/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.If you specify `walking` for the travel mode and your data provider is Esri, the start and destination must be within 40km.
 */
public suspend inline fun LocationClient.calculateRoute(crossinline block: CalculateRouteRequest.Builder.() -> Unit): CalculateRouteResponse = calculateRoute(CalculateRouteRequest.Builder().apply(block).build())

/**
 * [ Calculates a route matrix](https://docs.aws.amazon.com/location/previous/developerguide/calculate-route-matrix.html) given the following required parameters: `DeparturePositions` and `DestinationPositions`. `CalculateRouteMatrix` calculates routes and returns the travel time and travel distance from each departure position to each destination position in the request. For example, given departure positions A and B, and destination positions X and Y, `CalculateRouteMatrix` will return time and distance for routes from A to X, A to Y, B to X, and B to Y (in that order). The number of results returned (and routes calculated) will be the number of `DeparturePositions` times the number of `DestinationPositions`.
 *
 * Your account is charged for each route calculated, not the number of requests.
 *
 * Requires that you first [create a route calculator resource](https://docs.aws.amazon.com/location-routes/latest/APIReference/API_CreateRouteCalculator.html).
 *
 * By default, a request that doesn't specify a departure time uses the best time of day to travel with the best traffic conditions when calculating routes.
 *
 * Additional options include:
 * + [ Specifying a departure time](https://docs.aws.amazon.com/location/previous/developerguide/departure-time.html) using either `DepartureTime` or `DepartNow`. This calculates routes based on predictive traffic data at the given time. You can't specify both `DepartureTime` and `DepartNow` in a single request. Specifying both parameters returns a validation error.
 * + [Specifying a travel mode](https://docs.aws.amazon.com/location/previous/developerguide/travel-mode.html) using TravelMode sets the transportation mode used to calculate the routes. This also lets you specify additional route preferences in `CarModeOptions` if traveling by `Car`, or `TruckModeOptions` if traveling by `Truck`.
 */
public suspend inline fun LocationClient.calculateRouteMatrix(crossinline block: CalculateRouteMatrixRequest.Builder.() -> Unit): CalculateRouteMatrixResponse = calculateRouteMatrix(CalculateRouteMatrixRequest.Builder().apply(block).build())

/**
 * Creates a geofence collection, which manages and stores geofences.
 */
public suspend inline fun LocationClient.createGeofenceCollection(crossinline block: CreateGeofenceCollectionRequest.Builder.() -> Unit): CreateGeofenceCollectionResponse = createGeofenceCollection(CreateGeofenceCollectionRequest.Builder().apply(block).build())

/**
 * Creates an API key resource in your Amazon Web Services account, which lets you grant actions for Amazon Location resources to the API key bearer.
 *
 * For more information, see [Using API keys](https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html).
 */
public suspend inline fun LocationClient.createKey(crossinline block: CreateKeyRequest.Builder.() -> Unit): CreateKeyResponse = createKey(CreateKeyRequest.Builder().apply(block).build())

/**
 * Creates a map resource in your Amazon Web Services account, which provides map tiles of different styles sourced from global location data providers.
 *
 * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you must not use Esri as your geolocation provider. See section 82 of the [Amazon Web Services service terms](http://aws.amazon.com/service-terms) for more details.
 */
public suspend inline fun LocationClient.createMap(crossinline block: CreateMapRequest.Builder.() -> Unit): CreateMapResponse = createMap(CreateMapRequest.Builder().apply(block).build())

/**
 * Creates a place index resource in your Amazon Web Services account. Use a place index resource to geocode addresses and other text queries by using the `SearchPlaceIndexForText` operation, and reverse geocode coordinates by using the `SearchPlaceIndexForPosition` operation, and enable autosuggestions by using the `SearchPlaceIndexForSuggestions` operation.
 *
 * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you must not use Esri as your geolocation provider. See section 82 of the [Amazon Web Services service terms](http://aws.amazon.com/service-terms) for more details.
 */
public suspend inline fun LocationClient.createPlaceIndex(crossinline block: CreatePlaceIndexRequest.Builder.() -> Unit): CreatePlaceIndexResponse = createPlaceIndex(CreatePlaceIndexRequest.Builder().apply(block).build())

/**
 * Creates a route calculator resource in your Amazon Web Services account.
 *
 * You can send requests to a route calculator resource to estimate travel time, distance, and get directions. A route calculator sources traffic and road network data from your chosen data provider.
 *
 * If your application is tracking or routing assets you use in your business, such as delivery vehicles or employees, you must not use Esri as your geolocation provider. See section 82 of the [Amazon Web Services service terms](http://aws.amazon.com/service-terms) for more details.
 */
public suspend inline fun LocationClient.createRouteCalculator(crossinline block: CreateRouteCalculatorRequest.Builder.() -> Unit): CreateRouteCalculatorResponse = createRouteCalculator(CreateRouteCalculatorRequest.Builder().apply(block).build())

/**
 * Creates a tracker resource in your Amazon Web Services account, which lets you retrieve current and historical location of devices.
 */
public suspend inline fun LocationClient.createTracker(crossinline block: CreateTrackerRequest.Builder.() -> Unit): CreateTrackerResponse = createTracker(CreateTrackerRequest.Builder().apply(block).build())

/**
 * Deletes a geofence collection from your Amazon Web Services account.
 *
 * This operation deletes the resource permanently. If the geofence collection is the target of a tracker resource, the devices will no longer be monitored.
 */
public suspend inline fun LocationClient.deleteGeofenceCollection(crossinline block: DeleteGeofenceCollectionRequest.Builder.() -> Unit): DeleteGeofenceCollectionResponse = deleteGeofenceCollection(DeleteGeofenceCollectionRequest.Builder().apply(block).build())

/**
 * Deletes the specified API key. The API key must have been deactivated more than 90 days previously.
 */
public suspend inline fun LocationClient.deleteKey(crossinline block: DeleteKeyRequest.Builder.() -> Unit): DeleteKeyResponse = deleteKey(DeleteKeyRequest.Builder().apply(block).build())

/**
 * Deletes a map resource from your Amazon Web Services account.
 *
 * This operation deletes the resource permanently. If the map is being used in an application, the map may not render.
 */
public suspend inline fun LocationClient.deleteMap(crossinline block: DeleteMapRequest.Builder.() -> Unit): DeleteMapResponse = deleteMap(DeleteMapRequest.Builder().apply(block).build())

/**
 * Deletes a place index resource from your Amazon Web Services account.
 *
 * This operation deletes the resource permanently.
 */
public suspend inline fun LocationClient.deletePlaceIndex(crossinline block: DeletePlaceIndexRequest.Builder.() -> Unit): DeletePlaceIndexResponse = deletePlaceIndex(DeletePlaceIndexRequest.Builder().apply(block).build())

/**
 * Deletes a route calculator resource from your Amazon Web Services account.
 *
 * This operation deletes the resource permanently.
 */
public suspend inline fun LocationClient.deleteRouteCalculator(crossinline block: DeleteRouteCalculatorRequest.Builder.() -> Unit): DeleteRouteCalculatorResponse = deleteRouteCalculator(DeleteRouteCalculatorRequest.Builder().apply(block).build())

/**
 * Deletes a tracker resource from your Amazon Web Services account.
 *
 * This operation deletes the resource permanently. If the tracker resource is in use, you may encounter an error. Make sure that the target resource isn't a dependency for your applications.
 */
public suspend inline fun LocationClient.deleteTracker(crossinline block: DeleteTrackerRequest.Builder.() -> Unit): DeleteTrackerResponse = deleteTracker(DeleteTrackerRequest.Builder().apply(block).build())

/**
 * Retrieves the geofence collection details.
 */
public suspend inline fun LocationClient.describeGeofenceCollection(crossinline block: DescribeGeofenceCollectionRequest.Builder.() -> Unit): DescribeGeofenceCollectionResponse = describeGeofenceCollection(DescribeGeofenceCollectionRequest.Builder().apply(block).build())

/**
 * Retrieves the API key resource details.
 */
public suspend inline fun LocationClient.describeKey(crossinline block: DescribeKeyRequest.Builder.() -> Unit): DescribeKeyResponse = describeKey(DescribeKeyRequest.Builder().apply(block).build())

/**
 * Retrieves the map resource details.
 */
public suspend inline fun LocationClient.describeMap(crossinline block: DescribeMapRequest.Builder.() -> Unit): DescribeMapResponse = describeMap(DescribeMapRequest.Builder().apply(block).build())

/**
 * Retrieves the place index resource details.
 */
public suspend inline fun LocationClient.describePlaceIndex(crossinline block: DescribePlaceIndexRequest.Builder.() -> Unit): DescribePlaceIndexResponse = describePlaceIndex(DescribePlaceIndexRequest.Builder().apply(block).build())

/**
 * Retrieves the route calculator resource details.
 */
public suspend inline fun LocationClient.describeRouteCalculator(crossinline block: DescribeRouteCalculatorRequest.Builder.() -> Unit): DescribeRouteCalculatorResponse = describeRouteCalculator(DescribeRouteCalculatorRequest.Builder().apply(block).build())

/**
 * Retrieves the tracker resource details.
 */
public suspend inline fun LocationClient.describeTracker(crossinline block: DescribeTrackerRequest.Builder.() -> Unit): DescribeTrackerResponse = describeTracker(DescribeTrackerRequest.Builder().apply(block).build())

/**
 * Removes the association between a tracker resource and a geofence collection.
 *
 * Once you unlink a tracker resource from a geofence collection, the tracker positions will no longer be automatically evaluated against geofences.
 */
public suspend inline fun LocationClient.disassociateTrackerConsumer(crossinline block: DisassociateTrackerConsumerRequest.Builder.() -> Unit): DisassociateTrackerConsumerResponse = disassociateTrackerConsumer(DisassociateTrackerConsumerRequest.Builder().apply(block).build())

/**
 * This action forecasts future geofence events that are likely to occur within a specified time horizon if a device continues moving at its current speed. Each forecasted event is associated with a geofence from a provided geofence collection. A forecast event can have one of the following states:
 *
 * `ENTER`: The device position is outside the referenced geofence, but the device may cross into the geofence during the forecasting time horizon if it maintains its current speed.
 *
 * `EXIT`: The device position is inside the referenced geofence, but the device may leave the geofence during the forecasted time horizon if the device maintains it's current speed.
 *
 * `IDLE`:The device is inside the geofence, and it will remain inside the geofence through the end of the time horizon if the device maintains it's current speed.
 *
 * Heading direction is not considered in the current version. The API takes a conservative approach and includes events that can occur for any heading.
 */
public suspend inline fun LocationClient.forecastGeofenceEvents(crossinline block: ForecastGeofenceEventsRequest.Builder.() -> Unit): ForecastGeofenceEventsResponse = forecastGeofenceEvents(ForecastGeofenceEventsRequest.Builder().apply(block).build())

/**
 * Retrieves a device's most recent position according to its sample time.
 *
 * Device positions are deleted after 30 days.
 */
public suspend inline fun LocationClient.getDevicePosition(crossinline block: GetDevicePositionRequest.Builder.() -> Unit): GetDevicePositionResponse = getDevicePosition(GetDevicePositionRequest.Builder().apply(block).build())

/**
 * Retrieves the device position history from a tracker resource within a specified range of time.
 *
 * Device positions are deleted after 30 days.
 */
public suspend inline fun LocationClient.getDevicePositionHistory(crossinline block: GetDevicePositionHistoryRequest.Builder.() -> Unit): GetDevicePositionHistoryResponse = getDevicePositionHistory(GetDevicePositionHistoryRequest.Builder().apply(block).build())

/**
 * Retrieves the geofence details from a geofence collection.
 *
 * The returned geometry will always match the geometry format used when the geofence was created.
 */
public suspend inline fun LocationClient.getGeofence(crossinline block: GetGeofenceRequest.Builder.() -> Unit): GetGeofenceResponse = getGeofence(GetGeofenceRequest.Builder().apply(block).build())

/**
 * Retrieves glyphs used to display labels on a map.
 */
public suspend inline fun LocationClient.getMapGlyphs(crossinline block: GetMapGlyphsRequest.Builder.() -> Unit): GetMapGlyphsResponse = getMapGlyphs(GetMapGlyphsRequest.Builder().apply(block).build())

/**
 * Retrieves the sprite sheet corresponding to a map resource. The sprite sheet is a PNG image paired with a JSON document describing the offsets of individual icons that will be displayed on a rendered map.
 */
public suspend inline fun LocationClient.getMapSprites(crossinline block: GetMapSpritesRequest.Builder.() -> Unit): GetMapSpritesResponse = getMapSprites(GetMapSpritesRequest.Builder().apply(block).build())

/**
 * Retrieves the map style descriptor from a map resource.
 *
 * The style descriptor contains speciﬁcations on how features render on a map. For example, what data to display, what order to display the data in, and the style for the data. Style descriptors follow the Mapbox Style Specification.
 */
public suspend inline fun LocationClient.getMapStyleDescriptor(crossinline block: GetMapStyleDescriptorRequest.Builder.() -> Unit): GetMapStyleDescriptorResponse = getMapStyleDescriptor(GetMapStyleDescriptorRequest.Builder().apply(block).build())

/**
 * Retrieves a vector data tile from the map resource. Map tiles are used by clients to render a map. they're addressed using a grid arrangement with an X coordinate, Y coordinate, and Z (zoom) level.
 *
 * The origin (0, 0) is the top left of the map. Increasing the zoom level by 1 doubles both the X and Y dimensions, so a tile containing data for the entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1, 1/1/0, 1/1/1).
 */
public suspend inline fun LocationClient.getMapTile(crossinline block: GetMapTileRequest.Builder.() -> Unit): GetMapTileResponse = getMapTile(GetMapTileRequest.Builder().apply(block).build())

/**
 * Finds a place by its unique ID. A `PlaceId` is returned by other search operations.
 *
 * A PlaceId is valid only if all of the following are the same in the original search request and the call to `GetPlace`.
 * + Customer Amazon Web Services account
 * + Amazon Web Services Region
 * + Data provider specified in the place index resource
 * If your Place index resource is configured with Grab as your geolocation provider and Storage as Intended use, the GetPlace operation is unavailable. For more information, see [AWS service terms](http://aws.amazon.com/service-terms).
 */
public suspend inline fun LocationClient.getPlace(crossinline block: GetPlaceRequest.Builder.() -> Unit): GetPlaceResponse = getPlace(GetPlaceRequest.Builder().apply(block).build())

/**
 * A batch request to retrieve all device positions.
 */
public suspend inline fun LocationClient.listDevicePositions(crossinline block: ListDevicePositionsRequest.Builder.() -> Unit): ListDevicePositionsResponse = listDevicePositions(ListDevicePositionsRequest.Builder().apply(block).build())

/**
 * Lists geofence collections in your Amazon Web Services account.
 */
public suspend inline fun LocationClient.listGeofenceCollections(crossinline block: ListGeofenceCollectionsRequest.Builder.() -> Unit): ListGeofenceCollectionsResponse = listGeofenceCollections(ListGeofenceCollectionsRequest.Builder().apply(block).build())

/**
 * Lists geofences stored in a given geofence collection.
 */
public suspend inline fun LocationClient.listGeofences(crossinline block: ListGeofencesRequest.Builder.() -> Unit): ListGeofencesResponse = listGeofences(ListGeofencesRequest.Builder().apply(block).build())

/**
 * Lists API key resources in your Amazon Web Services account.
 */
public suspend inline fun LocationClient.listKeys(crossinline block: ListKeysRequest.Builder.() -> Unit): ListKeysResponse = listKeys(ListKeysRequest.Builder().apply(block).build())

/**
 * Lists map resources in your Amazon Web Services account.
 */
public suspend inline fun LocationClient.listMaps(crossinline block: ListMapsRequest.Builder.() -> Unit): ListMapsResponse = listMaps(ListMapsRequest.Builder().apply(block).build())

/**
 * Lists place index resources in your Amazon Web Services account.
 */
public suspend inline fun LocationClient.listPlaceIndexes(crossinline block: ListPlaceIndexesRequest.Builder.() -> Unit): ListPlaceIndexesResponse = listPlaceIndexes(ListPlaceIndexesRequest.Builder().apply(block).build())

/**
 * Lists route calculator resources in your Amazon Web Services account.
 */
public suspend inline fun LocationClient.listRouteCalculators(crossinline block: ListRouteCalculatorsRequest.Builder.() -> Unit): ListRouteCalculatorsResponse = listRouteCalculators(ListRouteCalculatorsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags that are applied to the specified Amazon Location resource.
 */
public suspend inline fun LocationClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists geofence collections currently associated to the given tracker resource.
 */
public suspend inline fun LocationClient.listTrackerConsumers(crossinline block: ListTrackerConsumersRequest.Builder.() -> Unit): ListTrackerConsumersResponse = listTrackerConsumers(ListTrackerConsumersRequest.Builder().apply(block).build())

/**
 * Lists tracker resources in your Amazon Web Services account.
 */
public suspend inline fun LocationClient.listTrackers(crossinline block: ListTrackersRequest.Builder.() -> Unit): ListTrackersResponse = listTrackers(ListTrackersRequest.Builder().apply(block).build())

/**
 * Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request.
 */
public suspend inline fun LocationClient.putGeofence(crossinline block: PutGeofenceRequest.Builder.() -> Unit): PutGeofenceResponse = putGeofence(PutGeofenceRequest.Builder().apply(block).build())

/**
 * Reverse geocodes a given coordinate and returns a legible address. Allows you to search for Places or points of interest near a given position.
 */
public suspend inline fun LocationClient.searchPlaceIndexForPosition(crossinline block: SearchPlaceIndexForPositionRequest.Builder.() -> Unit): SearchPlaceIndexForPositionResponse = searchPlaceIndexForPosition(SearchPlaceIndexForPositionRequest.Builder().apply(block).build())

/**
 * Generates suggestions for addresses and points of interest based on partial or misspelled free-form text. This operation is also known as autocomplete, autosuggest, or fuzzy matching.
 *
 * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
 *
 * You can search for suggested place names near a specified position by using `BiasPosition`, or filter results within a bounding box by using `FilterBBox`. These parameters are mutually exclusive; using both `BiasPosition` and `FilterBBox` in the same command returns an error.
 */
public suspend inline fun LocationClient.searchPlaceIndexForSuggestions(crossinline block: SearchPlaceIndexForSuggestionsRequest.Builder.() -> Unit): SearchPlaceIndexForSuggestionsResponse = searchPlaceIndexForSuggestions(SearchPlaceIndexForSuggestionsRequest.Builder().apply(block).build())

/**
 * Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of interest.
 *
 * Optional parameters let you narrow your search results by bounding box or country, or bias your search toward a specific position on the globe.
 *
 * You can search for places near a given position using `BiasPosition`, or filter results within a bounding box using `FilterBBox`. Providing both parameters simultaneously returns an error.
 *
 * Search results are returned in order of highest to lowest relevance.
 */
public suspend inline fun LocationClient.searchPlaceIndexForText(crossinline block: SearchPlaceIndexForTextRequest.Builder.() -> Unit): SearchPlaceIndexForTextResponse = searchPlaceIndexForText(SearchPlaceIndexForTextRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.
 *
 * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values.
 *
 * You can use the `TagResource` operation with an Amazon Location Service resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the tags already associated with the resource. If you specify a tag key that's already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate up to 50 tags with a resource.
 */
public suspend inline fun LocationClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified Amazon Location resource.
 */
public suspend inline fun LocationClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified properties of a given geofence collection.
 */
public suspend inline fun LocationClient.updateGeofenceCollection(crossinline block: UpdateGeofenceCollectionRequest.Builder.() -> Unit): UpdateGeofenceCollectionResponse = updateGeofenceCollection(UpdateGeofenceCollectionRequest.Builder().apply(block).build())

/**
 * Updates the specified properties of a given API key resource.
 */
public suspend inline fun LocationClient.updateKey(crossinline block: UpdateKeyRequest.Builder.() -> Unit): UpdateKeyResponse = updateKey(UpdateKeyRequest.Builder().apply(block).build())

/**
 * Updates the specified properties of a given map resource.
 */
public suspend inline fun LocationClient.updateMap(crossinline block: UpdateMapRequest.Builder.() -> Unit): UpdateMapResponse = updateMap(UpdateMapRequest.Builder().apply(block).build())

/**
 * Updates the specified properties of a given place index resource.
 */
public suspend inline fun LocationClient.updatePlaceIndex(crossinline block: UpdatePlaceIndexRequest.Builder.() -> Unit): UpdatePlaceIndexResponse = updatePlaceIndex(UpdatePlaceIndexRequest.Builder().apply(block).build())

/**
 * Updates the specified properties for a given route calculator resource.
 */
public suspend inline fun LocationClient.updateRouteCalculator(crossinline block: UpdateRouteCalculatorRequest.Builder.() -> Unit): UpdateRouteCalculatorResponse = updateRouteCalculator(UpdateRouteCalculatorRequest.Builder().apply(block).build())

/**
 * Updates the specified properties of a given tracker resource.
 */
public suspend inline fun LocationClient.updateTracker(crossinline block: UpdateTrackerRequest.Builder.() -> Unit): UpdateTrackerResponse = updateTracker(UpdateTrackerRequest.Builder().apply(block).build())

/**
 * Verifies the integrity of the device's position by determining if it was reported behind a proxy, and by comparing it to an inferred position estimated based on the device's state.
 *
 * The Location Integrity SDK provides enhanced features related to device verification, and it is available for use by request. To get access to the SDK, contact [Sales Support](https://aws.amazon.com/contact-us/sales-support/?pg=locationprice&cta=herobtn).
 */
public suspend inline fun LocationClient.verifyDevicePosition(crossinline block: VerifyDevicePositionRequest.Builder.() -> Unit): VerifyDevicePositionResponse = verifyDevicePosition(VerifyDevicePositionRequest.Builder().apply(block).build())
