// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.transform

import aws.sdk.kotlin.services.lightsail.model.CacheBehavior
import aws.sdk.kotlin.services.lightsail.model.CacheBehaviorPerPath
import aws.sdk.kotlin.services.lightsail.model.CacheSettings
import aws.sdk.kotlin.services.lightsail.model.InputOrigin
import aws.sdk.kotlin.services.lightsail.model.UpdateDistributionRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDistributionOperationSerializer: HttpSerialize<UpdateDistributionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateDistributionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeUpdateDistributionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateDistributionOperationBody(context: ExecutionContext, input: UpdateDistributionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CACHEBEHAVIORSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cacheBehaviorSettings"))
    val CACHEBEHAVIORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("cacheBehaviors"))
    val DEFAULTCACHEBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("defaultCacheBehavior"))
    val DISTRIBUTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("distributionName"))
    val ISENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isEnabled"))
    val ORIGIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("origin"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CACHEBEHAVIORSETTINGS_DESCRIPTOR)
        field(CACHEBEHAVIORS_DESCRIPTOR)
        field(DEFAULTCACHEBEHAVIOR_DESCRIPTOR)
        field(DISTRIBUTIONNAME_DESCRIPTOR)
        field(ISENABLED_DESCRIPTOR)
        field(ORIGIN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.cacheBehaviorSettings?.let { field(CACHEBEHAVIORSETTINGS_DESCRIPTOR, it, ::serializeCacheSettingsDocument) }
        if (input.cacheBehaviors != null) {
            listField(CACHEBEHAVIORS_DESCRIPTOR) {
                for (el0 in input.cacheBehaviors) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCacheBehaviorPerPathDocument))
                }
            }
        }
        input.defaultCacheBehavior?.let { field(DEFAULTCACHEBEHAVIOR_DESCRIPTOR, it, ::serializeCacheBehaviorDocument) }
        input.distributionName?.let { field(DISTRIBUTIONNAME_DESCRIPTOR, it) }
        input.isEnabled?.let { field(ISENABLED_DESCRIPTOR, it) }
        input.origin?.let { field(ORIGIN_DESCRIPTOR, it, ::serializeInputOriginDocument) }
    }
    return serializer.toByteArray()
}
