// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lightsail.model.GetStaticIpsResponse
import aws.sdk.kotlin.services.lightsail.model.LightsailException
import aws.sdk.kotlin.services.lightsail.model.StaticIp
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetStaticIpsOperationDeserializer: HttpDeserialize<GetStaticIpsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetStaticIpsResponse {
        if (!response.status.isSuccess()) {
            throwGetStaticIpsError(context, response)
        }
        val builder = GetStaticIpsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetStaticIpsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetStaticIpsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LightsailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AccountSetupInProgressException" -> AccountSetupInProgressExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationFailureException" -> OperationFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthenticatedException" -> UnauthenticatedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LightsailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetStaticIpsOperationBody(builder: GetStaticIpsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextPageToken"))
    val STATICIPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("staticIps"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(STATICIPS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                STATICIPS_DESCRIPTOR.index -> builder.staticIps =
                    deserializer.deserializeList(STATICIPS_DESCRIPTOR) {
                        val col0 = mutableListOf<StaticIp>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStaticIpDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
