// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lightsail.model.GetStaticIpResponse
import aws.sdk.kotlin.services.lightsail.model.LightsailException
import aws.sdk.kotlin.services.lightsail.model.StaticIp
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetStaticIpOperationDeserializer: HttpDeserialize<GetStaticIpResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetStaticIpResponse {
        if (!response.status.isSuccess()) {
            throwGetStaticIpError(context, response)
        }
        val builder = GetStaticIpResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetStaticIpOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetStaticIpError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LightsailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AccountSetupInProgressException" -> AccountSetupInProgressExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationFailureException" -> OperationFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthenticatedException" -> UnauthenticatedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LightsailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetStaticIpOperationBody(builder: GetStaticIpResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val STATICIP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("staticIp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(STATICIP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                STATICIP_DESCRIPTOR.index -> builder.staticIp = deserializeStaticIpDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
