// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.lightsail.model.DownloadDefaultKeyPairResponse
import aws.sdk.kotlin.services.lightsail.model.LightsailException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DownloadDefaultKeyPairOperationDeserializer: HttpDeserialize<DownloadDefaultKeyPairResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DownloadDefaultKeyPairResponse {
        if (!response.status.isSuccess()) {
            throwDownloadDefaultKeyPairError(context, response)
        }
        val builder = DownloadDefaultKeyPairResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDownloadDefaultKeyPairOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDownloadDefaultKeyPairError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LightsailException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AccountSetupInProgressException" -> AccountSetupInProgressExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationFailureException" -> OperationFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthenticatedException" -> UnauthenticatedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LightsailException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDownloadDefaultKeyPairOperationBody(builder: DownloadDefaultKeyPairResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val PRIVATEKEYBASE64_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("privateKeyBase64"))
    val PUBLICKEYBASE64_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("publicKeyBase64"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(PRIVATEKEYBASE64_DESCRIPTOR)
        field(PUBLICKEYBASE64_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                PRIVATEKEYBASE64_DESCRIPTOR.index -> builder.privateKeyBase64 = deserializeString()
                PUBLICKEYBASE64_DESCRIPTOR.index -> builder.publicKeyBase64 = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
