// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class UpdateRelationalDatabaseRequest private constructor(builder: Builder) {
    /**
     * When `true`, applies changes immediately. When `false`, applies changes during the preferred maintenance window. Some changes may cause an outage.
     *
     * Default: `false`
     */
    public val applyImmediately: kotlin.Boolean? = builder.applyImmediately
    /**
     * Indicates the certificate that needs to be associated with the database.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * When `true`, disables automated backup retention for your database.
     *
     * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database using the `create relational database snapshot` operation.
     *
     * Updates are applied during the next maintenance window because this can result in an outage.
     */
    public val disableBackupRetention: kotlin.Boolean? = builder.disableBackupRetention
    /**
     * When `true`, enables automated backup retention for your database.
     *
     * Updates are applied during the next maintenance window because this can result in an outage.
     */
    public val enableBackupRetention: kotlin.Boolean? = builder.enableBackupRetention
    /**
     * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
     *
     * My**SQL**
     *
     * Constraints: Must contain from 8 to 41 characters.
     *
     * **PostgreSQL**
     *
     * Constraints: Must contain from 8 to 128 characters.
     */
    public val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The daily time range during which automated backups are created for your database if automated backups are enabled.
     *
     * Constraints:
     * + Must be in the `hh24:mi-hh24:mi` format.Example: `16:00-16:30`
     * + Specified in Coordinated Universal Time (UTC).
     * + Must not conflict with the preferred maintenance window.
     * + Must be at least 30 minutes.
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur on your database.
     *
     * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.
     *
     * Constraints:
     * + Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
     * + Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * + Must be at least 30 minutes.
     * + Specified in Coordinated Universal Time (UTC).
     * + Example: `Tue:17:00-Tue:17:30`
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * Specifies the accessibility options for your database. A value of `true` specifies a database that is available to resources outside of your Lightsail account. A value of `false` specifies a database that is available only to your Lightsail resources in the same region as your database.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The name of your Lightsail database resource to update.
     */
    public val relationalDatabaseName: kotlin.String? = builder.relationalDatabaseName
    /**
     * When `true`, the master user password is changed to a new strong password generated by Lightsail.
     *
     * Use the `get relational database master user password` operation to get the new password.
     */
    public val rotateMasterUserPassword: kotlin.Boolean? = builder.rotateMasterUserPassword

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.UpdateRelationalDatabaseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRelationalDatabaseRequest(")
        append("applyImmediately=$applyImmediately,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("disableBackupRetention=$disableBackupRetention,")
        append("enableBackupRetention=$enableBackupRetention,")
        append("masterUserPassword=*** Sensitive Data Redacted ***,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("relationalDatabaseName=$relationalDatabaseName,")
        append("rotateMasterUserPassword=$rotateMasterUserPassword)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyImmediately?.hashCode() ?: 0
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (disableBackupRetention?.hashCode() ?: 0)
        result = 31 * result + (enableBackupRetention?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (rotateMasterUserPassword?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRelationalDatabaseRequest

        if (applyImmediately != other.applyImmediately) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (disableBackupRetention != other.disableBackupRetention) return false
        if (enableBackupRetention != other.enableBackupRetention) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (relationalDatabaseName != other.relationalDatabaseName) return false
        if (rotateMasterUserPassword != other.rotateMasterUserPassword) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.UpdateRelationalDatabaseRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When `true`, applies changes immediately. When `false`, applies changes during the preferred maintenance window. Some changes may cause an outage.
         *
         * Default: `false`
         */
        public var applyImmediately: kotlin.Boolean? = null
        /**
         * Indicates the certificate that needs to be associated with the database.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * When `true`, disables automated backup retention for your database.
         *
         * Disabling backup retention deletes all automated database backups. Before disabling this, you may want to create a snapshot of your database using the `create relational database snapshot` operation.
         *
         * Updates are applied during the next maintenance window because this can result in an outage.
         */
        public var disableBackupRetention: kotlin.Boolean? = null
        /**
         * When `true`, enables automated backup retention for your database.
         *
         * Updates are applied during the next maintenance window because this can result in an outage.
         */
        public var enableBackupRetention: kotlin.Boolean? = null
        /**
         * The password for the master user. The password can include any printable ASCII character except "/", """, or "@".
         *
         * My**SQL**
         *
         * Constraints: Must contain from 8 to 41 characters.
         *
         * **PostgreSQL**
         *
         * Constraints: Must contain from 8 to 128 characters.
         */
        public var masterUserPassword: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created for your database if automated backups are enabled.
         *
         * Constraints:
         * + Must be in the `hh24:mi-hh24:mi` format.Example: `16:00-16:30`
         * + Specified in Coordinated Universal Time (UTC).
         * + Must not conflict with the preferred maintenance window.
         * + Must be at least 30 minutes.
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur on your database.
         *
         * The default is a 30-minute window selected at random from an 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the week.
         *
         * Constraints:
         * + Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
         * + Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * + Must be at least 30 minutes.
         * + Specified in Coordinated Universal Time (UTC).
         * + Example: `Tue:17:00-Tue:17:30`
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * Specifies the accessibility options for your database. A value of `true` specifies a database that is available to resources outside of your Lightsail account. A value of `false` specifies a database that is available only to your Lightsail resources in the same region as your database.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The name of your Lightsail database resource to update.
         */
        public var relationalDatabaseName: kotlin.String? = null
        /**
         * When `true`, the master user password is changed to a new strong password generated by Lightsail.
         *
         * Use the `get relational database master user password` operation to get the new password.
         */
        public var rotateMasterUserPassword: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.UpdateRelationalDatabaseRequest) : this() {
            this.applyImmediately = x.applyImmediately
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.disableBackupRetention = x.disableBackupRetention
            this.enableBackupRetention = x.enableBackupRetention
            this.masterUserPassword = x.masterUserPassword
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.relationalDatabaseName = x.relationalDatabaseName
            this.rotateMasterUserPassword = x.rotateMasterUserPassword
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.UpdateRelationalDatabaseRequest = UpdateRelationalDatabaseRequest(this)
    }
}
