// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



/**
 * The password data for the Windows Server-based instance, including the ciphertext and the key pair name.
 */
public class PasswordData private constructor(builder: Builder) {
    /**
     * The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready yet. When you create an instance, it can take up to 15 minutes for the instance to be ready.
     *
     * If you use the default key pair (`LightsailDefaultKeyPair`), the decrypted password will be available in the password field.
     *
     * If you are using a custom key pair, you need to use your own means of decryption.
     *
     * If you change the Administrator password on the instance, Lightsail will continue to return the original ciphertext value. When accessing the instance using RDP, you need to manually enter the Administrator password after changing it from the default.
     */
    public val ciphertext: kotlin.String? = builder.ciphertext
    /**
     * The name of the key pair that you used when creating your instance. If no key pair name was specified when creating the instance, Lightsail uses the default key pair (`LightsailDefaultKeyPair`).
     *
     * If you are using a custom key pair, you need to use your own means of decrypting your password using the `ciphertext`. Lightsail creates the ciphertext by encrypting your password with the public key part of this key pair.
     */
    public val keyPairName: kotlin.String? = builder.keyPairName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.PasswordData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PasswordData(")
        append("ciphertext=$ciphertext,")
        append("keyPairName=$keyPairName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ciphertext?.hashCode() ?: 0
        result = 31 * result + (keyPairName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PasswordData

        if (ciphertext != other.ciphertext) return false
        if (keyPairName != other.keyPairName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.PasswordData = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The encrypted password. Ciphertext will be an empty string if access to your new instance is not ready yet. When you create an instance, it can take up to 15 minutes for the instance to be ready.
         *
         * If you use the default key pair (`LightsailDefaultKeyPair`), the decrypted password will be available in the password field.
         *
         * If you are using a custom key pair, you need to use your own means of decryption.
         *
         * If you change the Administrator password on the instance, Lightsail will continue to return the original ciphertext value. When accessing the instance using RDP, you need to manually enter the Administrator password after changing it from the default.
         */
        public var ciphertext: kotlin.String? = null
        /**
         * The name of the key pair that you used when creating your instance. If no key pair name was specified when creating the instance, Lightsail uses the default key pair (`LightsailDefaultKeyPair`).
         *
         * If you are using a custom key pair, you need to use your own means of decrypting your password using the `ciphertext`. Lightsail creates the ciphertext by encrypting your password with the public key part of this key pair.
         */
        public var keyPairName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.PasswordData) : this() {
            this.ciphertext = x.ciphertext
            this.keyPairName = x.keyPairName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.PasswordData = PasswordData(this)
    }
}
