// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetContainerServiceMetricDataRequest private constructor(builder: Builder) {
    /**
     * The end time of the time period.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = requireNotNull(builder.endTime) { "A non-null value must be provided for endTime" }
    /**
     * The metric for which you want to return information.
     *
     * Valid container service metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.
     * + `CPUUtilization` - The average percentage of compute units that are currently in use across all nodes of the container service. This metric identifies the processing power required to run containers on each node of the container service.Statistics: The most useful statistics are `Maximum` and `Average`.Unit: The published unit is `Percent`.
     * + `MemoryUtilization` - The average percentage of available memory that is currently in use across all nodes of the container service. This metric identifies the memory required to run containers on each node of the container service.Statistics: The most useful statistics are `Maximum` and `Average`.Unit: The published unit is `Percent`.
     */
    public val metricName: aws.sdk.kotlin.services.lightsail.model.ContainerServiceMetricName? = requireNotNull(builder.metricName) { "A non-null value must be provided for metricName" }
    /**
     * The granularity, in seconds, of the returned data points.
     *
     * All container service metric data is available in 5-minute (300 seconds) granularity.
     */
    public val period: kotlin.Int = requireNotNull(builder.period) { "A non-null value must be provided for period" }
    /**
     * The name of the container service for which to get metric data.
     */
    public val serviceName: kotlin.String? = requireNotNull(builder.serviceName) { "A non-null value must be provided for serviceName" }
    /**
     * The start time of the time period.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The statistic for the metric.
     *
     * The following statistics are available:
     * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
     * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
     * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
     * + `Average` - The value of `Sum` / `SampleCount` during the specified period. By comparing this statistic with the `Minimum` and `Maximum` values, you can determine the full scope of a metric and how close the average use is to the `Minimum` and `Maximum` values. This comparison helps you to know when to increase or decrease your resources.
     * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
     */
    public val statistics: List<MetricStatistic>? = requireNotNull(builder.statistics) { "A non-null value must be provided for statistics" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.GetContainerServiceMetricDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetContainerServiceMetricDataRequest(")
        append("endTime=$endTime,")
        append("metricName=$metricName,")
        append("period=$period,")
        append("serviceName=$serviceName,")
        append("startTime=$startTime,")
        append("statistics=$statistics)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (period)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetContainerServiceMetricDataRequest

        if (endTime != other.endTime) return false
        if (metricName != other.metricName) return false
        if (period != other.period) return false
        if (serviceName != other.serviceName) return false
        if (startTime != other.startTime) return false
        if (statistics != other.statistics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.GetContainerServiceMetricDataRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end time of the time period.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metric for which you want to return information.
         *
         * Valid container service metric names are listed below, along with the most useful statistics to include in your request, and the published unit value.
         * + `CPUUtilization` - The average percentage of compute units that are currently in use across all nodes of the container service. This metric identifies the processing power required to run containers on each node of the container service.Statistics: The most useful statistics are `Maximum` and `Average`.Unit: The published unit is `Percent`.
         * + `MemoryUtilization` - The average percentage of available memory that is currently in use across all nodes of the container service. This metric identifies the memory required to run containers on each node of the container service.Statistics: The most useful statistics are `Maximum` and `Average`.Unit: The published unit is `Percent`.
         */
        public var metricName: aws.sdk.kotlin.services.lightsail.model.ContainerServiceMetricName? = null
        /**
         * The granularity, in seconds, of the returned data points.
         *
         * All container service metric data is available in 5-minute (300 seconds) granularity.
         */
        public var period: kotlin.Int = 0
        /**
         * The name of the container service for which to get metric data.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The start time of the time period.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistic for the metric.
         *
         * The following statistics are available:
         * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
         * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
         * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
         * + `Average` - The value of `Sum` / `SampleCount` during the specified period. By comparing this statistic with the `Minimum` and `Maximum` values, you can determine the full scope of a metric and how close the average use is to the `Minimum` and `Maximum` values. This comparison helps you to know when to increase or decrease your resources.
         * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
         */
        public var statistics: List<MetricStatistic>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.GetContainerServiceMetricDataRequest) : this() {
            this.endTime = x.endTime
            this.metricName = x.metricName
            this.period = x.period
            this.serviceName = x.serviceName
            this.startTime = x.startTime
            this.statistics = x.statistics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.GetContainerServiceMetricDataRequest = GetContainerServiceMetricDataRequest(this)
    }
}
