// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model



public class CreateBucketRequest private constructor(builder: Builder) {
    /**
     * The name for the bucket.
     *
     * For more information about bucket names, see [Bucket naming rules in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The ID of the bundle to use for the bucket.
     *
     * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
     *
     * Use the [GetBucketBundles](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketBundles.html) action to get a list of bundle IDs that you can specify.
     *
     * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to change the bundle after the bucket is created.
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * A Boolean value that indicates whether to enable versioning of objects in the bucket.
     *
     * For more information about versioning, see [Enabling and suspending object versioning in a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning) in the *Amazon Lightsail Developer Guide*.
     */
    public val enableObjectVersioning: kotlin.Boolean? = builder.enableObjectVersioning
    /**
     * The tag keys and optional values to add to the bucket during creation.
     *
     * Use the [TagResource](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_TagResource.html) action to tag the bucket after it's created.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateBucketRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBucketRequest(")
        append("bucketName=$bucketName,")
        append("bundleId=$bundleId,")
        append("enableObjectVersioning=$enableObjectVersioning,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (bundleId?.hashCode() ?: 0)
        result = 31 * result + (enableObjectVersioning?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBucketRequest

        if (bucketName != other.bucketName) return false
        if (bundleId != other.bundleId) return false
        if (enableObjectVersioning != other.enableObjectVersioning) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateBucketRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name for the bucket.
         *
         * For more information about bucket names, see [Bucket naming rules in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/bucket-naming-rules-in-amazon-lightsail) in the *Amazon Lightsail Developer Guide*.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The ID of the bundle to use for the bucket.
         *
         * A bucket bundle specifies the monthly cost, storage space, and data transfer quota for a bucket.
         *
         * Use the [GetBucketBundles](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetBucketBundles.html) action to get a list of bundle IDs that you can specify.
         *
         * Use the [UpdateBucketBundle](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html) action to change the bundle after the bucket is created.
         */
        public var bundleId: kotlin.String? = null
        /**
         * A Boolean value that indicates whether to enable versioning of objects in the bucket.
         *
         * For more information about versioning, see [Enabling and suspending object versioning in a bucket in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-managing-bucket-object-versioning) in the *Amazon Lightsail Developer Guide*.
         */
        public var enableObjectVersioning: kotlin.Boolean? = null
        /**
         * The tag keys and optional values to add to the bucket during creation.
         *
         * Use the [TagResource](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_TagResource.html) action to tag the bucket after it's created.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateBucketRequest) : this() {
            this.bucketName = x.bucketName
            this.bundleId = x.bundleId
            this.enableObjectVersioning = x.enableObjectVersioning
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateBucketRequest = CreateBucketRequest(this)
    }
}
