// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.serde

import aws.sdk.kotlin.services.lightsail.model.CacheBehavior
import aws.sdk.kotlin.services.lightsail.model.CacheBehaviorPerPath
import aws.sdk.kotlin.services.lightsail.model.CacheSettings
import aws.sdk.kotlin.services.lightsail.model.InputOrigin
import aws.sdk.kotlin.services.lightsail.model.UpdateDistributionRequest
import aws.sdk.kotlin.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDistributionOperationSerializer: HttpSerializer.NonStreaming<UpdateDistributionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateDistributionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateDistributionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateDistributionOperationBody(context: ExecutionContext, input: UpdateDistributionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CACHEBEHAVIORSETTINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("cacheBehaviorSettings"))
    val CACHEBEHAVIORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("cacheBehaviors"))
    val CERTIFICATENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("certificateName"))
    val DEFAULTCACHEBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("defaultCacheBehavior"))
    val DISTRIBUTIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("distributionName"))
    val ISENABLED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isEnabled"))
    val ORIGIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("origin"))
    val USEDEFAULTCERTIFICATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("useDefaultCertificate"))
    val VIEWERMINIMUMTLSPROTOCOLVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("viewerMinimumTlsProtocolVersion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CACHEBEHAVIORSETTINGS_DESCRIPTOR)
        field(CACHEBEHAVIORS_DESCRIPTOR)
        field(CERTIFICATENAME_DESCRIPTOR)
        field(DEFAULTCACHEBEHAVIOR_DESCRIPTOR)
        field(DISTRIBUTIONNAME_DESCRIPTOR)
        field(ISENABLED_DESCRIPTOR)
        field(ORIGIN_DESCRIPTOR)
        field(USEDEFAULTCERTIFICATE_DESCRIPTOR)
        field(VIEWERMINIMUMTLSPROTOCOLVERSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.cacheBehaviorSettings?.let { field(CACHEBEHAVIORSETTINGS_DESCRIPTOR, it, ::serializeCacheSettingsDocument) }
        if (input.cacheBehaviors != null) {
            listField(CACHEBEHAVIORS_DESCRIPTOR) {
                for (el0 in input.cacheBehaviors) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCacheBehaviorPerPathDocument))
                }
            }
        }
        input.certificateName?.let { field(CERTIFICATENAME_DESCRIPTOR, it) }
        input.defaultCacheBehavior?.let { field(DEFAULTCACHEBEHAVIOR_DESCRIPTOR, it, ::serializeCacheBehaviorDocument) }
        input.distributionName?.let { field(DISTRIBUTIONNAME_DESCRIPTOR, it) }
        input.isEnabled?.let { field(ISENABLED_DESCRIPTOR, it) }
        input.origin?.let { field(ORIGIN_DESCRIPTOR, it, ::serializeInputOriginDocument) }
        input.useDefaultCertificate?.let { field(USEDEFAULTCERTIFICATE_DESCRIPTOR, it) }
        input.viewerMinimumTlsProtocolVersion?.let { field(VIEWERMINIMUMTLSPROTOCOLVERSION_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
