// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.serde

import aws.sdk.kotlin.services.lightsail.model.AccessRules
import aws.sdk.kotlin.services.lightsail.model.BucketAccessLogConfig
import aws.sdk.kotlin.services.lightsail.model.UpdateBucketRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBucketOperationSerializer: HttpSerializer.NonStreaming<UpdateBucketRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateBucketRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateBucketOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateBucketOperationBody(context: ExecutionContext, input: UpdateBucketRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSLOGCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessLogConfig"))
    val ACCESSRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("accessRules"))
    val BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("bucketName"))
    val READONLYACCESSACCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("readonlyAccessAccounts"))
    val VERSIONING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("versioning"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSLOGCONFIG_DESCRIPTOR)
        field(ACCESSRULES_DESCRIPTOR)
        field(BUCKETNAME_DESCRIPTOR)
        field(READONLYACCESSACCOUNTS_DESCRIPTOR)
        field(VERSIONING_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessLogConfig?.let { field(ACCESSLOGCONFIG_DESCRIPTOR, it, ::serializeBucketAccessLogConfigDocument) }
        input.accessRules?.let { field(ACCESSRULES_DESCRIPTOR, it, ::serializeAccessRulesDocument) }
        input.bucketName?.let { field(BUCKETNAME_DESCRIPTOR, it) }
        if (input.readonlyAccessAccounts != null) {
            listField(READONLYACCESSACCOUNTS_DESCRIPTOR) {
                for (el0 in input.readonlyAccessAccounts) {
                    serializeString(el0)
                }
            }
        }
        input.versioning?.let { field(VERSIONING_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
