// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.serde

import aws.sdk.kotlin.services.lightsail.model.ContainerServiceDeploymentRequest
import aws.sdk.kotlin.services.lightsail.model.ContainerServicePowerName
import aws.sdk.kotlin.services.lightsail.model.CreateContainerServiceRequest
import aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest
import aws.sdk.kotlin.services.lightsail.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateContainerServiceOperationSerializer: HttpSerializer.NonStreaming<CreateContainerServiceRequest> {
    override fun serialize(context: ExecutionContext, input: CreateContainerServiceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateContainerServiceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateContainerServiceOperationBody(context: ExecutionContext, input: CreateContainerServiceRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEPLOYMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deployment"))
    val POWER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("power"))
    val PRIVATEREGISTRYACCESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("privateRegistryAccess"))
    val PUBLICDOMAINNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("publicDomainNames"))
    val PUBLICDOMAINNAMES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SCALE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("scale"))
    val SERVICENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceName"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENT_DESCRIPTOR)
        field(POWER_DESCRIPTOR)
        field(PRIVATEREGISTRYACCESS_DESCRIPTOR)
        field(PUBLICDOMAINNAMES_DESCRIPTOR)
        field(SCALE_DESCRIPTOR)
        field(SERVICENAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.deployment?.let { field(DEPLOYMENT_DESCRIPTOR, it, ::serializeContainerServiceDeploymentRequestDocument) }
        input.power?.let { field(POWER_DESCRIPTOR, it.value) }
        input.privateRegistryAccess?.let { field(PRIVATEREGISTRYACCESS_DESCRIPTOR, it, ::serializePrivateRegistryAccessRequestDocument) }
        if (input.publicDomainNames != null) {
            mapField(PUBLICDOMAINNAMES_DESCRIPTOR) {
                input.publicDomainNames.forEach { (key, value) ->
                    listEntry(key, PUBLICDOMAINNAMES_C0_DESCRIPTOR) {
                        for (el1 in value) {
                            serializeString(el1)
                        }
                    }
                }
            }
        }
        input.scale?.let { field(SCALE_DESCRIPTOR, it) }
        input.serviceName?.let { field(SERVICENAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
