// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateLoadBalancerAttributeRequest private constructor(builder: Builder) {
    /**
     * The name of the attribute you want to update.
     */
    public val attributeName: aws.sdk.kotlin.services.lightsail.model.LoadBalancerAttributeName? = builder.attributeName
    /**
     * The value that you want to specify for the attribute name.
     *
     * The following values are supported depending on what you specify for the `attributeName` request parameter:
     * + If you specify `HealthCheckPath` for the `attributeName` request parameter, then the `attributeValue` request parameter must be the path to ping on the target (for example, `/weather/us/wa/seattle`).
     * + If you specify `SessionStickinessEnabled` for the `attributeName` request parameter, then the `attributeValue` request parameter must be `true` to activate session stickiness or `false` to deactivate session stickiness.
     * + If you specify `SessionStickiness_LB_CookieDurationSeconds` for the `attributeName` request parameter, then the `attributeValue` request parameter must be an interger that represents the cookie duration in seconds.
     * + If you specify `HttpsRedirectionEnabled` for the `attributeName` request parameter, then the `attributeValue` request parameter must be `true` to activate HTTP to HTTPS redirection or `false` to deactivate HTTP to HTTPS redirection.
     * + If you specify `TlsPolicyName` for the `attributeName` request parameter, then the `attributeValue` request parameter must be the name of the TLS policy.Use the [GetLoadBalancerTlsPolicies](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetLoadBalancerTlsPolicies.html) action to get a list of TLS policy names that you can specify.
     */
    public val attributeValue: kotlin.String? = builder.attributeValue
    /**
     * The name of the load balancer that you want to modify (`my-load-balancer`.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.UpdateLoadBalancerAttributeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLoadBalancerAttributeRequest(")
        append("attributeName=$attributeName,")
        append("attributeValue=$attributeValue,")
        append("loadBalancerName=$loadBalancerName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (attributeValue?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLoadBalancerAttributeRequest

        if (attributeName != other.attributeName) return false
        if (attributeValue != other.attributeValue) return false
        if (loadBalancerName != other.loadBalancerName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.UpdateLoadBalancerAttributeRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the attribute you want to update.
         */
        public var attributeName: aws.sdk.kotlin.services.lightsail.model.LoadBalancerAttributeName? = null
        /**
         * The value that you want to specify for the attribute name.
         *
         * The following values are supported depending on what you specify for the `attributeName` request parameter:
         * + If you specify `HealthCheckPath` for the `attributeName` request parameter, then the `attributeValue` request parameter must be the path to ping on the target (for example, `/weather/us/wa/seattle`).
         * + If you specify `SessionStickinessEnabled` for the `attributeName` request parameter, then the `attributeValue` request parameter must be `true` to activate session stickiness or `false` to deactivate session stickiness.
         * + If you specify `SessionStickiness_LB_CookieDurationSeconds` for the `attributeName` request parameter, then the `attributeValue` request parameter must be an interger that represents the cookie duration in seconds.
         * + If you specify `HttpsRedirectionEnabled` for the `attributeName` request parameter, then the `attributeValue` request parameter must be `true` to activate HTTP to HTTPS redirection or `false` to deactivate HTTP to HTTPS redirection.
         * + If you specify `TlsPolicyName` for the `attributeName` request parameter, then the `attributeValue` request parameter must be the name of the TLS policy.Use the [GetLoadBalancerTlsPolicies](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetLoadBalancerTlsPolicies.html) action to get a list of TLS policy names that you can specify.
         */
        public var attributeValue: kotlin.String? = null
        /**
         * The name of the load balancer that you want to modify (`my-load-balancer`.
         */
        public var loadBalancerName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.UpdateLoadBalancerAttributeRequest) : this() {
            this.attributeName = x.attributeName
            this.attributeValue = x.attributeValue
            this.loadBalancerName = x.loadBalancerName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.UpdateLoadBalancerAttributeRequest = UpdateLoadBalancerAttributeRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
