// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateDistributionRequest private constructor(builder: Builder) {
    /**
     * An object that describes the cache behavior settings for the distribution.
     *
     * The `cacheBehaviorSettings` specified in your `UpdateDistributionRequest` will replace your distribution's existing settings.
     */
    public val cacheBehaviorSettings: aws.sdk.kotlin.services.lightsail.model.CacheSettings? = builder.cacheBehaviorSettings
    /**
     * An array of objects that describe the per-path cache behavior for the distribution.
     */
    public val cacheBehaviors: List<CacheBehaviorPerPath>? = builder.cacheBehaviors
    /**
     * The name of the SSL/TLS certificate that you want to attach to the distribution.
     *
     * Only certificates with a status of `ISSUED` can be attached to a distribution.
     *
     * Use the [GetCertificates](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetCertificates.html) action to get a list of certificate names that you can specify.
     */
    public val certificateName: kotlin.String? = builder.certificateName
    /**
     * An object that describes the default cache behavior for the distribution.
     */
    public val defaultCacheBehavior: aws.sdk.kotlin.services.lightsail.model.CacheBehavior? = builder.defaultCacheBehavior
    /**
     * The name of the distribution to update.
     *
     * Use the `GetDistributions` action to get a list of distribution names that you can specify.
     */
    public val distributionName: kotlin.String? = builder.distributionName
    /**
     * Indicates whether to enable the distribution.
     */
    public val isEnabled: kotlin.Boolean? = builder.isEnabled
    /**
     * An object that describes the origin resource for the distribution, such as a Lightsail instance, bucket, or load balancer.
     *
     * The distribution pulls, caches, and serves content from the origin.
     */
    public val origin: aws.sdk.kotlin.services.lightsail.model.InputOrigin? = builder.origin
    /**
     * Indicates whether the default SSL/TLS certificate is attached to the distribution. The default value is `true`. When `true`, the distribution uses the default domain name such as `d111111abcdef8.cloudfront.net`.
     *
     *  Set this value to `false` to attach a new certificate to the distribution.
     */
    public val useDefaultCertificate: kotlin.Boolean? = builder.useDefaultCertificate
    /**
     * Use this parameter to update the minimum TLS protocol version for the SSL/TLS certificate that's attached to the distribution.
     */
    public val viewerMinimumTlsProtocolVersion: aws.sdk.kotlin.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum? = builder.viewerMinimumTlsProtocolVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.UpdateDistributionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDistributionRequest(")
        append("cacheBehaviorSettings=$cacheBehaviorSettings,")
        append("cacheBehaviors=$cacheBehaviors,")
        append("certificateName=$certificateName,")
        append("defaultCacheBehavior=$defaultCacheBehavior,")
        append("distributionName=$distributionName,")
        append("isEnabled=$isEnabled,")
        append("origin=$origin,")
        append("useDefaultCertificate=$useDefaultCertificate,")
        append("viewerMinimumTlsProtocolVersion=$viewerMinimumTlsProtocolVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheBehaviorSettings?.hashCode() ?: 0
        result = 31 * result + (cacheBehaviors?.hashCode() ?: 0)
        result = 31 * result + (certificateName?.hashCode() ?: 0)
        result = 31 * result + (defaultCacheBehavior?.hashCode() ?: 0)
        result = 31 * result + (distributionName?.hashCode() ?: 0)
        result = 31 * result + (isEnabled?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (useDefaultCertificate?.hashCode() ?: 0)
        result = 31 * result + (viewerMinimumTlsProtocolVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDistributionRequest

        if (cacheBehaviorSettings != other.cacheBehaviorSettings) return false
        if (cacheBehaviors != other.cacheBehaviors) return false
        if (certificateName != other.certificateName) return false
        if (defaultCacheBehavior != other.defaultCacheBehavior) return false
        if (distributionName != other.distributionName) return false
        if (isEnabled != other.isEnabled) return false
        if (origin != other.origin) return false
        if (useDefaultCertificate != other.useDefaultCertificate) return false
        if (viewerMinimumTlsProtocolVersion != other.viewerMinimumTlsProtocolVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.UpdateDistributionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object that describes the cache behavior settings for the distribution.
         *
         * The `cacheBehaviorSettings` specified in your `UpdateDistributionRequest` will replace your distribution's existing settings.
         */
        public var cacheBehaviorSettings: aws.sdk.kotlin.services.lightsail.model.CacheSettings? = null
        /**
         * An array of objects that describe the per-path cache behavior for the distribution.
         */
        public var cacheBehaviors: List<CacheBehaviorPerPath>? = null
        /**
         * The name of the SSL/TLS certificate that you want to attach to the distribution.
         *
         * Only certificates with a status of `ISSUED` can be attached to a distribution.
         *
         * Use the [GetCertificates](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetCertificates.html) action to get a list of certificate names that you can specify.
         */
        public var certificateName: kotlin.String? = null
        /**
         * An object that describes the default cache behavior for the distribution.
         */
        public var defaultCacheBehavior: aws.sdk.kotlin.services.lightsail.model.CacheBehavior? = null
        /**
         * The name of the distribution to update.
         *
         * Use the `GetDistributions` action to get a list of distribution names that you can specify.
         */
        public var distributionName: kotlin.String? = null
        /**
         * Indicates whether to enable the distribution.
         */
        public var isEnabled: kotlin.Boolean? = null
        /**
         * An object that describes the origin resource for the distribution, such as a Lightsail instance, bucket, or load balancer.
         *
         * The distribution pulls, caches, and serves content from the origin.
         */
        public var origin: aws.sdk.kotlin.services.lightsail.model.InputOrigin? = null
        /**
         * Indicates whether the default SSL/TLS certificate is attached to the distribution. The default value is `true`. When `true`, the distribution uses the default domain name such as `d111111abcdef8.cloudfront.net`.
         *
         *  Set this value to `false` to attach a new certificate to the distribution.
         */
        public var useDefaultCertificate: kotlin.Boolean? = null
        /**
         * Use this parameter to update the minimum TLS protocol version for the SSL/TLS certificate that's attached to the distribution.
         */
        public var viewerMinimumTlsProtocolVersion: aws.sdk.kotlin.services.lightsail.model.ViewerMinimumTlsProtocolVersionEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.UpdateDistributionRequest) : this() {
            this.cacheBehaviorSettings = x.cacheBehaviorSettings
            this.cacheBehaviors = x.cacheBehaviors
            this.certificateName = x.certificateName
            this.defaultCacheBehavior = x.defaultCacheBehavior
            this.distributionName = x.distributionName
            this.isEnabled = x.isEnabled
            this.origin = x.origin
            this.useDefaultCertificate = x.useDefaultCertificate
            this.viewerMinimumTlsProtocolVersion = x.viewerMinimumTlsProtocolVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.UpdateDistributionRequest = UpdateDistributionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.CacheSettings] inside the given [block]
         */
        public fun cacheBehaviorSettings(block: aws.sdk.kotlin.services.lightsail.model.CacheSettings.Builder.() -> kotlin.Unit) {
            this.cacheBehaviorSettings = aws.sdk.kotlin.services.lightsail.model.CacheSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.CacheBehavior] inside the given [block]
         */
        public fun defaultCacheBehavior(block: aws.sdk.kotlin.services.lightsail.model.CacheBehavior.Builder.() -> kotlin.Unit) {
            this.defaultCacheBehavior = aws.sdk.kotlin.services.lightsail.model.CacheBehavior.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.InputOrigin] inside the given [block]
         */
        public fun origin(block: aws.sdk.kotlin.services.lightsail.model.InputOrigin.Builder.() -> kotlin.Unit) {
            this.origin = aws.sdk.kotlin.services.lightsail.model.InputOrigin.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
