// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateContainerServiceRequest private constructor(builder: Builder) {
    /**
     * A Boolean value to indicate whether the container service is disabled.
     */
    public val isDisabled: kotlin.Boolean? = builder.isDisabled
    /**
     * The power for the container service.
     *
     * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The `power` and `scale` of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the `power` with the `scale` (the number of nodes) of the service.
     *
     * Use the `GetContainerServicePowers` action to view the specifications of each power option.
     */
    public val power: aws.sdk.kotlin.services.lightsail.model.ContainerServicePowerName? = builder.power
    /**
     * An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
     *
     * For more information, see [Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access) in the *Amazon Lightsail Developer Guide*.
     */
    public val privateRegistryAccess: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest? = builder.privateRegistryAccess
    /**
     * The public domain names to use with the container service, such as `example.com` and `www.example.com`.
     *
     * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service.
     *
     * If you don't specify public domain names, then you can use the default domain of the container service.
     *
     * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the `CreateCertificate` action to create a certificate for the public domain names you want to use with your container service.
     *
     * You can specify public domain names using a string to array map as shown in the example later on this page.
     */
    public val publicDomainNames: Map<String, List<String>>? = builder.publicDomainNames
    /**
     * The scale for the container service.
     *
     * The scale specifies the allocated compute nodes of the container service. The `power` and `scale` of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the `power` with the `scale` (the number of nodes) of the service.
     */
    public val scale: kotlin.Int? = builder.scale
    /**
     * The name of the container service to update.
     */
    public val serviceName: kotlin.String? = builder.serviceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.UpdateContainerServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateContainerServiceRequest(")
        append("isDisabled=$isDisabled,")
        append("power=$power,")
        append("privateRegistryAccess=$privateRegistryAccess,")
        append("publicDomainNames=$publicDomainNames,")
        append("scale=$scale,")
        append("serviceName=$serviceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isDisabled?.hashCode() ?: 0
        result = 31 * result + (power?.hashCode() ?: 0)
        result = 31 * result + (privateRegistryAccess?.hashCode() ?: 0)
        result = 31 * result + (publicDomainNames?.hashCode() ?: 0)
        result = 31 * result + (scale ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateContainerServiceRequest

        if (isDisabled != other.isDisabled) return false
        if (power != other.power) return false
        if (privateRegistryAccess != other.privateRegistryAccess) return false
        if (publicDomainNames != other.publicDomainNames) return false
        if (scale != other.scale) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.UpdateContainerServiceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A Boolean value to indicate whether the container service is disabled.
         */
        public var isDisabled: kotlin.Boolean? = null
        /**
         * The power for the container service.
         *
         * The power specifies the amount of memory, vCPUs, and base monthly cost of each node of the container service. The `power` and `scale` of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the `power` with the `scale` (the number of nodes) of the service.
         *
         * Use the `GetContainerServicePowers` action to view the specifications of each power option.
         */
        public var power: aws.sdk.kotlin.services.lightsail.model.ContainerServicePowerName? = null
        /**
         * An object to describe the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry (Amazon ECR) private repositories.
         *
         * For more information, see [Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access) in the *Amazon Lightsail Developer Guide*.
         */
        public var privateRegistryAccess: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest? = null
        /**
         * The public domain names to use with the container service, such as `example.com` and `www.example.com`.
         *
         * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container configured as the public endpoint of your container service.
         *
         * If you don't specify public domain names, then you can use the default domain of the container service.
         *
         * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the `CreateCertificate` action to create a certificate for the public domain names you want to use with your container service.
         *
         * You can specify public domain names using a string to array map as shown in the example later on this page.
         */
        public var publicDomainNames: Map<String, List<String>>? = null
        /**
         * The scale for the container service.
         *
         * The scale specifies the allocated compute nodes of the container service. The `power` and `scale` of a container service makes up its configured capacity. To determine the monthly price of your container service, multiply the base price of the `power` with the `scale` (the number of nodes) of the service.
         */
        public var scale: kotlin.Int? = null
        /**
         * The name of the container service to update.
         */
        public var serviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.UpdateContainerServiceRequest) : this() {
            this.isDisabled = x.isDisabled
            this.power = x.power
            this.privateRegistryAccess = x.privateRegistryAccess
            this.publicDomainNames = x.publicDomainNames
            this.scale = x.scale
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.UpdateContainerServiceRequest = UpdateContainerServiceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest] inside the given [block]
         */
        public fun privateRegistryAccess(block: aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest.Builder.() -> kotlin.Unit) {
            this.privateRegistryAccess = aws.sdk.kotlin.services.lightsail.model.PrivateRegistryAccessRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
