// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Sets the start date and end date for retrieving a cost estimate. The start date is inclusive, but the end date is exclusive. For example, if `start` is `2017-01-01` and `end` is `2017-05-01`, then the cost and usage data is retrieved from `2017-01-01` up to and including `2017-04-30` but not including `2017-05-01`.
 */
public class TimePeriod private constructor(builder: Builder) {
    /**
     * The end of the time period. The end date is exclusive. For example, if `end` is `2017-05-01`, Lightsail for Research retrieves cost and usage data from the start date up to, but not including, `2017-05-01`.
     */
    public val end: aws.smithy.kotlin.runtime.time.Instant? = builder.end
    /**
     * The beginning of the time period. The start date is inclusive. For example, if `start` is `2017-01-01`, Lightsail for Research retrieves cost and usage data starting at `2017-01-01` up to the end date. The start date must be equal to or no later than the current date to avoid a validation error.
     */
    public val start: aws.smithy.kotlin.runtime.time.Instant? = builder.start

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.TimePeriod = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TimePeriod(")
        append("end=$end,")
        append("start=$start")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = end?.hashCode() ?: 0
        result = 31 * result + (start?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TimePeriod

        if (end != other.end) return false
        if (start != other.start) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.TimePeriod = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The end of the time period. The end date is exclusive. For example, if `end` is `2017-05-01`, Lightsail for Research retrieves cost and usage data from the start date up to, but not including, `2017-05-01`.
         */
        public var end: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The beginning of the time period. The start date is inclusive. For example, if `start` is `2017-01-01`, Lightsail for Research retrieves cost and usage data starting at `2017-01-01` up to the end date. The start date must be equal to or no later than the current date to avoid a validation error.
         */
        public var start: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.TimePeriod) : this() {
            this.end = x.end
            this.start = x.start
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.TimePeriod = TimePeriod(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
