// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a database.
 */
public class RelationalDatabase private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the database.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A Boolean value indicating whether automated backup retention is enabled for the database.
     */
    public val backupRetentionEnabled: kotlin.Boolean? = builder.backupRetentionEnabled
    /**
     * The certificate associated with the database.
     */
    public val caCertificateIdentifier: kotlin.String? = builder.caCertificateIdentifier
    /**
     * The timestamp when the database was created. Formatted in Unix time.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The database software (for example, `MySQL`).
     */
    public val engine: kotlin.String? = builder.engine
    /**
     * The database engine version (for example, `5.7.23`).
     */
    public val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * Describes the hardware of the database.
     */
    public val hardware: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseHardware? = builder.hardware
    /**
     * The latest point in time to which the database can be restored. Formatted in Unix time.
     */
    public val latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = builder.latestRestorableTime
    /**
     * The Region name and Availability Zone where the database is located.
     */
    public val location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = builder.location
    /**
     * The name of the master database created when the Lightsail database resource is created.
     */
    public val masterDatabaseName: kotlin.String? = builder.masterDatabaseName
    /**
     * The master endpoint for the database.
     */
    public val masterEndpoint: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseEndpoint? = builder.masterEndpoint
    /**
     * The master user name of the database.
     */
    public val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The unique name of the database resource in Lightsail.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The status of parameter updates for the database.
     */
    public val parameterApplyStatus: kotlin.String? = builder.parameterApplyStatus
    /**
     * Describes the pending maintenance actions for the database.
     */
    public val pendingMaintenanceActions: List<PendingMaintenanceAction>? = builder.pendingMaintenanceActions
    /**
     * Describes pending database value modifications.
     */
    public val pendingModifiedValues: aws.sdk.kotlin.services.lightsail.model.PendingModifiedRelationalDatabaseValues? = builder.pendingModifiedValues
    /**
     * The daily time range during which automated backups are created for the database (for example, `16:00-16:30`).
     */
    public val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur on the database.
     *
     * In the format `ddd:hh24:mi-ddd:hh24:mi`. For example, `Tue:17:00-Tue:17:30`.
     */
    public val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A Boolean value indicating whether the database is publicly accessible.
     */
    public val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The blueprint ID for the database. A blueprint describes the major engine version of a database.
     */
    public val relationalDatabaseBlueprintId: kotlin.String? = builder.relationalDatabaseBlueprintId
    /**
     * The bundle ID for the database. A bundle describes the performance specifications for your database.
     */
    public val relationalDatabaseBundleId: kotlin.String? = builder.relationalDatabaseBundleId
    /**
     * The Lightsail resource type for the database (for example, `RelationalDatabase`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = builder.resourceType
    /**
     * Describes the secondary Availability Zone of a high availability database.
     *
     * The secondary database is used for failover support of a high availability database.
     */
    public val secondaryAvailabilityZone: kotlin.String? = builder.secondaryAvailabilityZone
    /**
     * Describes the current state of the database.
     */
    public val state: kotlin.String? = builder.state
    /**
     * The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
     */
    public val supportCode: kotlin.String? = builder.supportCode
    /**
     * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.RelationalDatabase = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RelationalDatabase(")
        append("arn=$arn,")
        append("backupRetentionEnabled=$backupRetentionEnabled,")
        append("caCertificateIdentifier=$caCertificateIdentifier,")
        append("createdAt=$createdAt,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("hardware=$hardware,")
        append("latestRestorableTime=$latestRestorableTime,")
        append("location=$location,")
        append("masterDatabaseName=$masterDatabaseName,")
        append("masterEndpoint=$masterEndpoint,")
        append("masterUsername=$masterUsername,")
        append("name=$name,")
        append("parameterApplyStatus=$parameterApplyStatus,")
        append("pendingMaintenanceActions=$pendingMaintenanceActions,")
        append("pendingModifiedValues=$pendingModifiedValues,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("relationalDatabaseBlueprintId=$relationalDatabaseBlueprintId,")
        append("relationalDatabaseBundleId=$relationalDatabaseBundleId,")
        append("resourceType=$resourceType,")
        append("secondaryAvailabilityZone=$secondaryAvailabilityZone,")
        append("state=$state,")
        append("supportCode=$supportCode,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (backupRetentionEnabled?.hashCode() ?: 0)
        result = 31 * result + (caCertificateIdentifier?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (hardware?.hashCode() ?: 0)
        result = 31 * result + (latestRestorableTime?.hashCode() ?: 0)
        result = 31 * result + (location?.hashCode() ?: 0)
        result = 31 * result + (masterDatabaseName?.hashCode() ?: 0)
        result = 31 * result + (masterEndpoint?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parameterApplyStatus?.hashCode() ?: 0)
        result = 31 * result + (pendingMaintenanceActions?.hashCode() ?: 0)
        result = 31 * result + (pendingModifiedValues?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseBlueprintId?.hashCode() ?: 0)
        result = 31 * result + (relationalDatabaseBundleId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (secondaryAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (supportCode?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RelationalDatabase

        if (arn != other.arn) return false
        if (backupRetentionEnabled != other.backupRetentionEnabled) return false
        if (caCertificateIdentifier != other.caCertificateIdentifier) return false
        if (createdAt != other.createdAt) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (hardware != other.hardware) return false
        if (latestRestorableTime != other.latestRestorableTime) return false
        if (location != other.location) return false
        if (masterDatabaseName != other.masterDatabaseName) return false
        if (masterEndpoint != other.masterEndpoint) return false
        if (masterUsername != other.masterUsername) return false
        if (name != other.name) return false
        if (parameterApplyStatus != other.parameterApplyStatus) return false
        if (pendingMaintenanceActions != other.pendingMaintenanceActions) return false
        if (pendingModifiedValues != other.pendingModifiedValues) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (relationalDatabaseBlueprintId != other.relationalDatabaseBlueprintId) return false
        if (relationalDatabaseBundleId != other.relationalDatabaseBundleId) return false
        if (resourceType != other.resourceType) return false
        if (secondaryAvailabilityZone != other.secondaryAvailabilityZone) return false
        if (state != other.state) return false
        if (supportCode != other.supportCode) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.RelationalDatabase = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the database.
         */
        public var arn: kotlin.String? = null
        /**
         * A Boolean value indicating whether automated backup retention is enabled for the database.
         */
        public var backupRetentionEnabled: kotlin.Boolean? = null
        /**
         * The certificate associated with the database.
         */
        public var caCertificateIdentifier: kotlin.String? = null
        /**
         * The timestamp when the database was created. Formatted in Unix time.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The database software (for example, `MySQL`).
         */
        public var engine: kotlin.String? = null
        /**
         * The database engine version (for example, `5.7.23`).
         */
        public var engineVersion: kotlin.String? = null
        /**
         * Describes the hardware of the database.
         */
        public var hardware: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseHardware? = null
        /**
         * The latest point in time to which the database can be restored. Formatted in Unix time.
         */
        public var latestRestorableTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Region name and Availability Zone where the database is located.
         */
        public var location: aws.sdk.kotlin.services.lightsail.model.ResourceLocation? = null
        /**
         * The name of the master database created when the Lightsail database resource is created.
         */
        public var masterDatabaseName: kotlin.String? = null
        /**
         * The master endpoint for the database.
         */
        public var masterEndpoint: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseEndpoint? = null
        /**
         * The master user name of the database.
         */
        public var masterUsername: kotlin.String? = null
        /**
         * The unique name of the database resource in Lightsail.
         */
        public var name: kotlin.String? = null
        /**
         * The status of parameter updates for the database.
         */
        public var parameterApplyStatus: kotlin.String? = null
        /**
         * Describes the pending maintenance actions for the database.
         */
        public var pendingMaintenanceActions: List<PendingMaintenanceAction>? = null
        /**
         * Describes pending database value modifications.
         */
        public var pendingModifiedValues: aws.sdk.kotlin.services.lightsail.model.PendingModifiedRelationalDatabaseValues? = null
        /**
         * The daily time range during which automated backups are created for the database (for example, `16:00-16:30`).
         */
        public var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur on the database.
         *
         * In the format `ddd:hh24:mi-ddd:hh24:mi`. For example, `Tue:17:00-Tue:17:30`.
         */
        public var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A Boolean value indicating whether the database is publicly accessible.
         */
        public var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The blueprint ID for the database. A blueprint describes the major engine version of a database.
         */
        public var relationalDatabaseBlueprintId: kotlin.String? = null
        /**
         * The bundle ID for the database. A bundle describes the performance specifications for your database.
         */
        public var relationalDatabaseBundleId: kotlin.String? = null
        /**
         * The Lightsail resource type for the database (for example, `RelationalDatabase`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ResourceType? = null
        /**
         * Describes the secondary Availability Zone of a high availability database.
         *
         * The secondary database is used for failover support of a high availability database.
         */
        public var secondaryAvailabilityZone: kotlin.String? = null
        /**
         * Describes the current state of the database.
         */
        public var state: kotlin.String? = null
        /**
         * The support code for the database. Include this code in your email to support when you have questions about a database in Lightsail. This code enables our support team to look up your Lightsail information more easily.
         */
        public var supportCode: kotlin.String? = null
        /**
         * The tag keys and optional values for the resource. For more information about tags in Lightsail, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.RelationalDatabase) : this() {
            this.arn = x.arn
            this.backupRetentionEnabled = x.backupRetentionEnabled
            this.caCertificateIdentifier = x.caCertificateIdentifier
            this.createdAt = x.createdAt
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.hardware = x.hardware
            this.latestRestorableTime = x.latestRestorableTime
            this.location = x.location
            this.masterDatabaseName = x.masterDatabaseName
            this.masterEndpoint = x.masterEndpoint
            this.masterUsername = x.masterUsername
            this.name = x.name
            this.parameterApplyStatus = x.parameterApplyStatus
            this.pendingMaintenanceActions = x.pendingMaintenanceActions
            this.pendingModifiedValues = x.pendingModifiedValues
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.relationalDatabaseBlueprintId = x.relationalDatabaseBlueprintId
            this.relationalDatabaseBundleId = x.relationalDatabaseBundleId
            this.resourceType = x.resourceType
            this.secondaryAvailabilityZone = x.secondaryAvailabilityZone
            this.state = x.state
            this.supportCode = x.supportCode
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.RelationalDatabase = RelationalDatabase(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseHardware] inside the given [block]
         */
        public fun hardware(block: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseHardware.Builder.() -> kotlin.Unit) {
            this.hardware = aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseHardware.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.ResourceLocation] inside the given [block]
         */
        public fun location(block: aws.sdk.kotlin.services.lightsail.model.ResourceLocation.Builder.() -> kotlin.Unit) {
            this.location = aws.sdk.kotlin.services.lightsail.model.ResourceLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseEndpoint] inside the given [block]
         */
        public fun masterEndpoint(block: aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseEndpoint.Builder.() -> kotlin.Unit) {
            this.masterEndpoint = aws.sdk.kotlin.services.lightsail.model.RelationalDatabaseEndpoint.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.PendingModifiedRelationalDatabaseValues] inside the given [block]
         */
        public fun pendingModifiedValues(block: aws.sdk.kotlin.services.lightsail.model.PendingModifiedRelationalDatabaseValues.Builder.() -> kotlin.Unit) {
            this.pendingModifiedValues = aws.sdk.kotlin.services.lightsail.model.PendingModifiedRelationalDatabaseValues.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
