// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the query string parameters that an Amazon Lightsail content delivery network (CDN) distribution to bases caching on.
 *
 * For the query strings that you specify, your distribution caches separate versions of the specified content based on the query string values in viewer requests.
 */
public class QueryStringObject private constructor(builder: Builder) {
    /**
     * Indicates whether the distribution forwards and caches based on query strings.
     */
    public val option: kotlin.Boolean? = builder.option
    /**
     * The specific query strings that the distribution forwards to the origin.
     *
     * Your distribution will cache content based on the specified query strings.
     *
     * If the `option` parameter is true, then your distribution forwards all query strings, regardless of what you specify using the `queryStringsAllowList` parameter.
     */
    public val queryStringsAllowList: List<String>? = builder.queryStringsAllowList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.QueryStringObject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryStringObject(")
        append("option=$option,")
        append("queryStringsAllowList=$queryStringsAllowList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = option?.hashCode() ?: 0
        result = 31 * result + (queryStringsAllowList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryStringObject

        if (option != other.option) return false
        if (queryStringsAllowList != other.queryStringsAllowList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.QueryStringObject = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the distribution forwards and caches based on query strings.
         */
        public var option: kotlin.Boolean? = null
        /**
         * The specific query strings that the distribution forwards to the origin.
         *
         * Your distribution will cache content based on the specified query strings.
         *
         * If the `option` parameter is true, then your distribution forwards all query strings, regardless of what you specify using the `queryStringsAllowList` parameter.
         */
        public var queryStringsAllowList: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.QueryStringObject) : this() {
            this.option = x.option
            this.queryStringsAllowList = x.queryStringsAllowList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.QueryStringObject = QueryStringObject(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
