// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutAlarmRequest private constructor(builder: Builder) {
    /**
     * The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration of the alarm.
     */
    public val alarmName: kotlin.String? = builder.alarmName
    /**
     * The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic value is used as the first operand.
     */
    public val comparisonOperator: aws.sdk.kotlin.services.lightsail.model.ComparisonOperator? = builder.comparisonOperator
    /**
     * The contact protocols to use for the alarm, such as `Email`, `SMS` (text messaging), or both.
     *
     * A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and when the alarm is triggered.
     *
     * A notification is not sent if a contact protocol is not specified, if the specified contact protocol is not configured in the Amazon Web Services Region, or if notifications are not enabled for the alarm using the `notificationEnabled` paramater.
     *
     * Use the `CreateContactMethod` action to configure a contact protocol in an Amazon Web Services Region.
     */
    public val contactProtocols: List<ContactProtocol>? = builder.contactProtocols
    /**
     * The number of data points that must be not within the specified threshold to trigger the alarm. If you are setting an "M out of N" alarm, this value (`datapointsToAlarm`) is the M.
     */
    public val datapointsToAlarm: kotlin.Int? = builder.datapointsToAlarm
    /**
     * The number of most recent periods over which data is compared to the specified threshold. If you are setting an "M out of N" alarm, this value (`evaluationPeriods`) is the N.
     *
     * If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the alarm, this value specifies the rolling period of time in which data points are evaluated.
     *
     * Each evaluation period is five minutes long. For example, specify an evaluation period of 24 to evaluate a metric over a rolling period of two hours.
     *
     * You can specify a minimum valuation period of 1 (5 minutes), and a maximum evaluation period of 288 (24 hours).
     */
    public val evaluationPeriods: kotlin.Int? = builder.evaluationPeriods
    /**
     * The name of the metric to associate with the alarm.
     *
     * You can configure up to two alarms per metric.
     *
     * The following metrics are available for each resource type:
     * + **Instances**: `BurstCapacityPercentage`, `BurstCapacityTime`, `CPUUtilization`, `NetworkIn`, `NetworkOut`, `StatusCheckFailed`, `StatusCheckFailed_Instance`, and `StatusCheckFailed_System`.
     * + **Load balancers**: `ClientTLSNegotiationErrorCount`, `HealthyHostCount`, `UnhealthyHostCount`, `HTTPCode_LB_4XX_Count`, `HTTPCode_LB_5XX_Count`, `HTTPCode_Instance_2XX_Count`, `HTTPCode_Instance_3XX_Count`, `HTTPCode_Instance_4XX_Count`, `HTTPCode_Instance_5XX_Count`, `InstanceResponseTime`, `RejectedConnectionCount`, and `RequestCount`.
     * + **Relational databases**: `CPUUtilization`, `DatabaseConnections`, `DiskQueueDepth`, `FreeStorageSpace`, `NetworkReceiveThroughput`, and `NetworkTransmitThroughput`.
     *
     * For more information about these metrics, see [Metrics available in Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics).
     */
    public val metricName: aws.sdk.kotlin.services.lightsail.model.MetricName? = builder.metricName
    /**
     * The name of the Lightsail resource that will be monitored.
     *
     * Instances, load balancers, and relational databases are the only Lightsail resources that can currently be monitored by alarms.
     */
    public val monitoredResourceName: kotlin.String? = builder.monitoredResourceName
    /**
     * Indicates whether the alarm is enabled.
     *
     * Notifications are enabled by default if you don't specify this parameter.
     */
    public val notificationEnabled: kotlin.Boolean? = builder.notificationEnabled
    /**
     * The alarm states that trigger a notification.
     *
     * An alarm has the following possible states:
     * + `ALARM` - The metric is outside of the defined threshold.
     * + `INSUFFICIENT_DATA` - The alarm has just started, the metric is not available, or not enough data is available for the metric to determine the alarm state.
     * + `OK` - The metric is within the defined threshold.
     *
     * When you specify a notification trigger, the `ALARM` state must be specified. The `INSUFFICIENT_DATA` and `OK` states can be specified in addition to the `ALARM` state.
     * + If you specify `OK` as an alarm trigger, a notification is sent when the alarm switches from an `ALARM` or `INSUFFICIENT_DATA` alarm state to an `OK` state. This can be thought of as an *all clear* alarm notification.
     * + If you specify `INSUFFICIENT_DATA` as the alarm trigger, a notification is sent when the alarm switches from an `OK` or `ALARM` alarm state to an `INSUFFICIENT_DATA` state.
     *
     * The notification trigger defaults to `ALARM` if you don't specify this parameter.
     */
    public val notificationTriggers: List<AlarmState>? = builder.notificationTriggers
    /**
     * The value against which the specified statistic is compared.
     */
    public val threshold: kotlin.Double? = builder.threshold
    /**
     * Sets how this alarm will handle missing data points.
     *
     * An alarm can treat missing data in the following ways:
     * + `breaching` - Assume the missing data is not within the threshold. Missing data counts towards the number of times the metric is not within the threshold.
     * + `notBreaching` - Assume the missing data is within the threshold. Missing data does not count towards the number of times the metric is not within the threshold.
     * + `ignore` - Ignore the missing data. Maintains the current alarm state.
     * + `missing` - Missing data is treated as missing.
     *
     * If `treatMissingData` is not specified, the default behavior of `missing` is used.
     */
    public val treatMissingData: aws.sdk.kotlin.services.lightsail.model.TreatMissingData? = builder.treatMissingData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.PutAlarmRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutAlarmRequest(")
        append("alarmName=$alarmName,")
        append("comparisonOperator=$comparisonOperator,")
        append("contactProtocols=$contactProtocols,")
        append("datapointsToAlarm=$datapointsToAlarm,")
        append("evaluationPeriods=$evaluationPeriods,")
        append("metricName=$metricName,")
        append("monitoredResourceName=$monitoredResourceName,")
        append("notificationEnabled=$notificationEnabled,")
        append("notificationTriggers=$notificationTriggers,")
        append("threshold=$threshold,")
        append("treatMissingData=$treatMissingData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmName?.hashCode() ?: 0
        result = 31 * result + (comparisonOperator?.hashCode() ?: 0)
        result = 31 * result + (contactProtocols?.hashCode() ?: 0)
        result = 31 * result + (datapointsToAlarm ?: 0)
        result = 31 * result + (evaluationPeriods ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (monitoredResourceName?.hashCode() ?: 0)
        result = 31 * result + (notificationEnabled?.hashCode() ?: 0)
        result = 31 * result + (notificationTriggers?.hashCode() ?: 0)
        result = 31 * result + (threshold?.hashCode() ?: 0)
        result = 31 * result + (treatMissingData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutAlarmRequest

        if (alarmName != other.alarmName) return false
        if (comparisonOperator != other.comparisonOperator) return false
        if (contactProtocols != other.contactProtocols) return false
        if (datapointsToAlarm != other.datapointsToAlarm) return false
        if (evaluationPeriods != other.evaluationPeriods) return false
        if (metricName != other.metricName) return false
        if (monitoredResourceName != other.monitoredResourceName) return false
        if (notificationEnabled != other.notificationEnabled) return false
        if (notificationTriggers != other.notificationTriggers) return false
        if (!(threshold?.equals(other.threshold) ?: (other.threshold == null))) return false
        if (treatMissingData != other.treatMissingData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.PutAlarmRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name for the alarm. Specify the name of an existing alarm to update, and overwrite the previous configuration of the alarm.
         */
        public var alarmName: kotlin.String? = null
        /**
         * The arithmetic operation to use when comparing the specified statistic to the threshold. The specified statistic value is used as the first operand.
         */
        public var comparisonOperator: aws.sdk.kotlin.services.lightsail.model.ComparisonOperator? = null
        /**
         * The contact protocols to use for the alarm, such as `Email`, `SMS` (text messaging), or both.
         *
         * A notification is sent via the specified contact protocol if notifications are enabled for the alarm, and when the alarm is triggered.
         *
         * A notification is not sent if a contact protocol is not specified, if the specified contact protocol is not configured in the Amazon Web Services Region, or if notifications are not enabled for the alarm using the `notificationEnabled` paramater.
         *
         * Use the `CreateContactMethod` action to configure a contact protocol in an Amazon Web Services Region.
         */
        public var contactProtocols: List<ContactProtocol>? = null
        /**
         * The number of data points that must be not within the specified threshold to trigger the alarm. If you are setting an "M out of N" alarm, this value (`datapointsToAlarm`) is the M.
         */
        public var datapointsToAlarm: kotlin.Int? = null
        /**
         * The number of most recent periods over which data is compared to the specified threshold. If you are setting an "M out of N" alarm, this value (`evaluationPeriods`) is the N.
         *
         * If you are setting an alarm that requires that a number of consecutive data points be breaching to trigger the alarm, this value specifies the rolling period of time in which data points are evaluated.
         *
         * Each evaluation period is five minutes long. For example, specify an evaluation period of 24 to evaluate a metric over a rolling period of two hours.
         *
         * You can specify a minimum valuation period of 1 (5 minutes), and a maximum evaluation period of 288 (24 hours).
         */
        public var evaluationPeriods: kotlin.Int? = null
        /**
         * The name of the metric to associate with the alarm.
         *
         * You can configure up to two alarms per metric.
         *
         * The following metrics are available for each resource type:
         * + **Instances**: `BurstCapacityPercentage`, `BurstCapacityTime`, `CPUUtilization`, `NetworkIn`, `NetworkOut`, `StatusCheckFailed`, `StatusCheckFailed_Instance`, and `StatusCheckFailed_System`.
         * + **Load balancers**: `ClientTLSNegotiationErrorCount`, `HealthyHostCount`, `UnhealthyHostCount`, `HTTPCode_LB_4XX_Count`, `HTTPCode_LB_5XX_Count`, `HTTPCode_Instance_2XX_Count`, `HTTPCode_Instance_3XX_Count`, `HTTPCode_Instance_4XX_Count`, `HTTPCode_Instance_5XX_Count`, `InstanceResponseTime`, `RejectedConnectionCount`, and `RequestCount`.
         * + **Relational databases**: `CPUUtilization`, `DatabaseConnections`, `DiskQueueDepth`, `FreeStorageSpace`, `NetworkReceiveThroughput`, and `NetworkTransmitThroughput`.
         *
         * For more information about these metrics, see [Metrics available in Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics).
         */
        public var metricName: aws.sdk.kotlin.services.lightsail.model.MetricName? = null
        /**
         * The name of the Lightsail resource that will be monitored.
         *
         * Instances, load balancers, and relational databases are the only Lightsail resources that can currently be monitored by alarms.
         */
        public var monitoredResourceName: kotlin.String? = null
        /**
         * Indicates whether the alarm is enabled.
         *
         * Notifications are enabled by default if you don't specify this parameter.
         */
        public var notificationEnabled: kotlin.Boolean? = null
        /**
         * The alarm states that trigger a notification.
         *
         * An alarm has the following possible states:
         * + `ALARM` - The metric is outside of the defined threshold.
         * + `INSUFFICIENT_DATA` - The alarm has just started, the metric is not available, or not enough data is available for the metric to determine the alarm state.
         * + `OK` - The metric is within the defined threshold.
         *
         * When you specify a notification trigger, the `ALARM` state must be specified. The `INSUFFICIENT_DATA` and `OK` states can be specified in addition to the `ALARM` state.
         * + If you specify `OK` as an alarm trigger, a notification is sent when the alarm switches from an `ALARM` or `INSUFFICIENT_DATA` alarm state to an `OK` state. This can be thought of as an *all clear* alarm notification.
         * + If you specify `INSUFFICIENT_DATA` as the alarm trigger, a notification is sent when the alarm switches from an `OK` or `ALARM` alarm state to an `INSUFFICIENT_DATA` state.
         *
         * The notification trigger defaults to `ALARM` if you don't specify this parameter.
         */
        public var notificationTriggers: List<AlarmState>? = null
        /**
         * The value against which the specified statistic is compared.
         */
        public var threshold: kotlin.Double? = null
        /**
         * Sets how this alarm will handle missing data points.
         *
         * An alarm can treat missing data in the following ways:
         * + `breaching` - Assume the missing data is not within the threshold. Missing data counts towards the number of times the metric is not within the threshold.
         * + `notBreaching` - Assume the missing data is within the threshold. Missing data does not count towards the number of times the metric is not within the threshold.
         * + `ignore` - Ignore the missing data. Maintains the current alarm state.
         * + `missing` - Missing data is treated as missing.
         *
         * If `treatMissingData` is not specified, the default behavior of `missing` is used.
         */
        public var treatMissingData: aws.sdk.kotlin.services.lightsail.model.TreatMissingData? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.PutAlarmRequest) : this() {
            this.alarmName = x.alarmName
            this.comparisonOperator = x.comparisonOperator
            this.contactProtocols = x.contactProtocols
            this.datapointsToAlarm = x.datapointsToAlarm
            this.evaluationPeriods = x.evaluationPeriods
            this.metricName = x.metricName
            this.monitoredResourceName = x.monitoredResourceName
            this.notificationEnabled = x.notificationEnabled
            this.notificationTriggers = x.notificationTriggers
            this.threshold = x.threshold
            this.treatMissingData = x.treatMissingData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.PutAlarmRequest = PutAlarmRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
