// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the status of Lightsail's managed renewal for the certificate.
 *
 * The renewal status of the certificate.
 *
 * The following renewal status are possible:
 * + **`PendingAutoRenewal`** - Lightsail is attempting to automatically validate the domain names in the certificate. No further action is required.
 * + **`PendingValidation`** - Lightsail couldn't automatically validate one or more domain names in the certificate. You must take action to validate these domain names or the certificate won't be renewed. If you used DNS validation, check to make sure your certificate's domain validation records exist in your domain's DNS, and that your certificate remains in use.
 * + **`Success`** - All domain names in the certificate are validated, and Lightsail renewed the certificate. No further action is required.
 * + **`Failed`** - One or more domain names were not validated before the certificate expired, and Lightsail did not renew the certificate. You can request a new certificate using the `CreateCertificate` action.
 */
public class LoadBalancerTlsCertificateRenewalSummary private constructor(builder: Builder) {
    /**
     * Contains information about the validation of each domain name in the certificate, as it pertains to Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the RequestCertificate request.
     */
    public val domainValidationOptions: List<LoadBalancerTlsCertificateDomainValidationOption>? = builder.domainValidationOptions
    /**
     * The renewal status of the certificate.
     *
     * The following renewal status are possible:
     * + **`PendingAutoRenewal`** - Lightsail is attempting to automatically validate the domain names of the certificate. No further action is required.
     * + **`PendingValidation`** - Lightsail couldn't automatically validate one or more domain names of the certificate. You must take action to validate these domain names or the certificate won't be renewed. Check to make sure your certificate's domain validation records exist in your domain's DNS, and that your certificate remains in use.
     * + **`Success`** - All domain names in the certificate are validated, and Lightsail renewed the certificate. No further action is required.
     * + **`Failed`** - One or more domain names were not validated before the certificate expired, and Lightsail did not renew the certificate. You can request a new certificate using the `CreateCertificate` action.
     */
    public val renewalStatus: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus? = builder.renewalStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerTlsCertificateRenewalSummary(")
        append("domainValidationOptions=$domainValidationOptions,")
        append("renewalStatus=$renewalStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = domainValidationOptions?.hashCode() ?: 0
        result = 31 * result + (renewalStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerTlsCertificateRenewalSummary

        if (domainValidationOptions != other.domainValidationOptions) return false
        if (renewalStatus != other.renewalStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains information about the validation of each domain name in the certificate, as it pertains to Lightsail's managed renewal. This is different from the initial validation that occurs as a result of the RequestCertificate request.
         */
        public var domainValidationOptions: List<LoadBalancerTlsCertificateDomainValidationOption>? = null
        /**
         * The renewal status of the certificate.
         *
         * The following renewal status are possible:
         * + **`PendingAutoRenewal`** - Lightsail is attempting to automatically validate the domain names of the certificate. No further action is required.
         * + **`PendingValidation`** - Lightsail couldn't automatically validate one or more domain names of the certificate. You must take action to validate these domain names or the certificate won't be renewed. Check to make sure your certificate's domain validation records exist in your domain's DNS, and that your certificate remains in use.
         * + **`Success`** - All domain names in the certificate are validated, and Lightsail renewed the certificate. No further action is required.
         * + **`Failed`** - One or more domain names were not validated before the certificate expired, and Lightsail did not renew the certificate. You can request a new certificate using the `CreateCertificate` action.
         */
        public var renewalStatus: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary) : this() {
            this.domainValidationOptions = x.domainValidationOptions
            this.renewalStatus = x.renewalStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary = LoadBalancerTlsCertificateRenewalSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
