// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the validation record of each domain name in the SSL/TLS certificate.
 */
public class LoadBalancerTlsCertificateDomainValidationRecord private constructor(builder: Builder) {
    /**
     * An object that describes the state of the canonical name (CNAME) records that are automatically added by Lightsail to the DNS of a domain to validate domain ownership.
     */
    public val dnsRecordCreationState: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState? = builder.dnsRecordCreationState
    /**
     * The domain name against which your SSL/TLS certificate was validated.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * A fully qualified domain name in the certificate. For example, `example.com`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of validation record. For example, `CNAME` for domain validation.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The validation status. Valid values are listed below.
     */
    public val validationStatus: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus? = builder.validationStatus
    /**
     * The value for that type.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerTlsCertificateDomainValidationRecord(")
        append("dnsRecordCreationState=$dnsRecordCreationState,")
        append("domainName=$domainName,")
        append("name=$name,")
        append("type=$type,")
        append("validationStatus=$validationStatus,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsRecordCreationState?.hashCode() ?: 0
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (validationStatus?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerTlsCertificateDomainValidationRecord

        if (dnsRecordCreationState != other.dnsRecordCreationState) return false
        if (domainName != other.domainName) return false
        if (name != other.name) return false
        if (type != other.type) return false
        if (validationStatus != other.validationStatus) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object that describes the state of the canonical name (CNAME) records that are automatically added by Lightsail to the DNS of a domain to validate domain ownership.
         */
        public var dnsRecordCreationState: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState? = null
        /**
         * The domain name against which your SSL/TLS certificate was validated.
         */
        public var domainName: kotlin.String? = null
        /**
         * A fully qualified domain name in the certificate. For example, `example.com`.
         */
        public var name: kotlin.String? = null
        /**
         * The type of validation record. For example, `CNAME` for domain validation.
         */
        public var type: kotlin.String? = null
        /**
         * The validation status. Valid values are listed below.
         */
        public var validationStatus: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus? = null
        /**
         * The value for that type.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord) : this() {
            this.dnsRecordCreationState = x.dnsRecordCreationState
            this.domainName = x.domainName
            this.name = x.name
            this.type = x.type
            this.validationStatus = x.validationStatus
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord = LoadBalancerTlsCertificateDomainValidationRecord(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState] inside the given [block]
         */
        public fun dnsRecordCreationState(block: aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState.Builder.() -> kotlin.Unit) {
            this.dnsRecordCreationState = aws.sdk.kotlin.services.lightsail.model.LoadBalancerTlsCertificateDnsRecordCreationState.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
