// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the public SSH host keys or the RDP certificate.
 */
public class HostKeyAttributes private constructor(builder: Builder) {
    /**
     * The SSH host key algorithm or the RDP certificate format.
     *
     * For SSH host keys, the algorithm may be `ssh-rsa`, `ecdsa-sha2-nistp256`, `ssh-ed25519`, etc. For RDP certificates, the algorithm is always `x509-cert`.
     */
    public val algorithm: kotlin.String? = builder.algorithm
    /**
     * The SHA-1 fingerprint of the returned SSH host key or RDP certificate.
     * + Example of an SHA-1 SSH fingerprint:`SHA1:1CHH6FaAaXjtFOsR/t83vf91SR0`
     * + Example of an SHA-1 RDP fingerprint:`af:34:51:fe:09:f0:e0:da:b8:4e:56:ca:60:c2:10:ff:38:06:db:45`
     */
    public val fingerprintSha1: kotlin.String? = builder.fingerprintSha1
    /**
     * The SHA-256 fingerprint of the returned SSH host key or RDP certificate.
     * + Example of an SHA-256 SSH fingerprint:`SHA256:KTsMnRBh1IhD17HpdfsbzeGA4jOijm5tyXsMjKVbB8o`
     * + Example of an SHA-256 RDP fingerprint:`03:9b:36:9f:4b:de:4e:61:70:fc:7c:c9:78:e7:d2:1a:1c:25:a8:0c:91:f6:7c:e4:d6:a0:85:c8:b4:53:99:68`
     */
    public val fingerprintSha256: kotlin.String? = builder.fingerprintSha256
    /**
     * The returned RDP certificate is not valid after this point in time.
     *
     * This value is listed only for RDP certificates.
     */
    public val notValidAfter: aws.smithy.kotlin.runtime.time.Instant? = builder.notValidAfter
    /**
     * The returned RDP certificate is valid after this point in time.
     *
     * This value is listed only for RDP certificates.
     */
    public val notValidBefore: aws.smithy.kotlin.runtime.time.Instant? = builder.notValidBefore
    /**
     * The public SSH host key or the RDP certificate.
     */
    public val publicKey: kotlin.String? = builder.publicKey
    /**
     * The time that the SSH host key or RDP certificate was recorded by Lightsail.
     */
    public val witnessedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.witnessedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.HostKeyAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HostKeyAttributes(")
        append("algorithm=$algorithm,")
        append("fingerprintSha1=$fingerprintSha1,")
        append("fingerprintSha256=$fingerprintSha256,")
        append("notValidAfter=$notValidAfter,")
        append("notValidBefore=$notValidBefore,")
        append("publicKey=$publicKey,")
        append("witnessedAt=$witnessedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = algorithm?.hashCode() ?: 0
        result = 31 * result + (fingerprintSha1?.hashCode() ?: 0)
        result = 31 * result + (fingerprintSha256?.hashCode() ?: 0)
        result = 31 * result + (notValidAfter?.hashCode() ?: 0)
        result = 31 * result + (notValidBefore?.hashCode() ?: 0)
        result = 31 * result + (publicKey?.hashCode() ?: 0)
        result = 31 * result + (witnessedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HostKeyAttributes

        if (algorithm != other.algorithm) return false
        if (fingerprintSha1 != other.fingerprintSha1) return false
        if (fingerprintSha256 != other.fingerprintSha256) return false
        if (notValidAfter != other.notValidAfter) return false
        if (notValidBefore != other.notValidBefore) return false
        if (publicKey != other.publicKey) return false
        if (witnessedAt != other.witnessedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.HostKeyAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The SSH host key algorithm or the RDP certificate format.
         *
         * For SSH host keys, the algorithm may be `ssh-rsa`, `ecdsa-sha2-nistp256`, `ssh-ed25519`, etc. For RDP certificates, the algorithm is always `x509-cert`.
         */
        public var algorithm: kotlin.String? = null
        /**
         * The SHA-1 fingerprint of the returned SSH host key or RDP certificate.
         * + Example of an SHA-1 SSH fingerprint:`SHA1:1CHH6FaAaXjtFOsR/t83vf91SR0`
         * + Example of an SHA-1 RDP fingerprint:`af:34:51:fe:09:f0:e0:da:b8:4e:56:ca:60:c2:10:ff:38:06:db:45`
         */
        public var fingerprintSha1: kotlin.String? = null
        /**
         * The SHA-256 fingerprint of the returned SSH host key or RDP certificate.
         * + Example of an SHA-256 SSH fingerprint:`SHA256:KTsMnRBh1IhD17HpdfsbzeGA4jOijm5tyXsMjKVbB8o`
         * + Example of an SHA-256 RDP fingerprint:`03:9b:36:9f:4b:de:4e:61:70:fc:7c:c9:78:e7:d2:1a:1c:25:a8:0c:91:f6:7c:e4:d6:a0:85:c8:b4:53:99:68`
         */
        public var fingerprintSha256: kotlin.String? = null
        /**
         * The returned RDP certificate is not valid after this point in time.
         *
         * This value is listed only for RDP certificates.
         */
        public var notValidAfter: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The returned RDP certificate is valid after this point in time.
         *
         * This value is listed only for RDP certificates.
         */
        public var notValidBefore: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The public SSH host key or the RDP certificate.
         */
        public var publicKey: kotlin.String? = null
        /**
         * The time that the SSH host key or RDP certificate was recorded by Lightsail.
         */
        public var witnessedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.HostKeyAttributes) : this() {
            this.algorithm = x.algorithm
            this.fingerprintSha1 = x.fingerprintSha1
            this.fingerprintSha256 = x.fingerprintSha256
            this.notValidAfter = x.notValidAfter
            this.notValidBefore = x.notValidBefore
            this.publicKey = x.publicKey
            this.witnessedAt = x.witnessedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.HostKeyAttributes = HostKeyAttributes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
