// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the request headers that a Lightsail distribution bases caching on.
 *
 * For the headers that you specify, your distribution caches separate versions of the specified content based on the header values in viewer requests. For example, suppose viewer requests for `logo.jpg` contain a custom `product` header that has a value of either `acme` or `apex`, and you configure your distribution to cache your content based on values in the `product` header. Your distribution forwards the `product` header to the origin and caches the response from the origin once for each header value.
 */
public class HeaderObject private constructor(builder: Builder) {
    /**
     * The specific headers to forward to your distribution's origin.
     */
    public val headersAllowList: List<HeaderEnum>? = builder.headersAllowList
    /**
     * The headers that you want your distribution to forward to your origin and base caching on.
     *
     * You can configure your distribution to do one of the following:
     * + **`all`** - Forward all headers to your origin.
     * + **`none`** - Forward only the default headers.
     * + **`allow-list`** - Forward only the headers you specify using the `headersAllowList` parameter.
     */
    public val option: aws.sdk.kotlin.services.lightsail.model.ForwardValues? = builder.option

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.HeaderObject = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HeaderObject(")
        append("headersAllowList=$headersAllowList,")
        append("option=$option")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = headersAllowList?.hashCode() ?: 0
        result = 31 * result + (option?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HeaderObject

        if (headersAllowList != other.headersAllowList) return false
        if (option != other.option) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.HeaderObject = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The specific headers to forward to your distribution's origin.
         */
        public var headersAllowList: List<HeaderEnum>? = null
        /**
         * The headers that you want your distribution to forward to your origin and base caching on.
         *
         * You can configure your distribution to do one of the following:
         * + **`all`** - Forward all headers to your origin.
         * + **`none`** - Forward only the default headers.
         * + **`allow-list`** - Forward only the headers you specify using the `headersAllowList` parameter.
         */
        public var option: aws.sdk.kotlin.services.lightsail.model.ForwardValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.HeaderObject) : this() {
            this.headersAllowList = x.headersAllowList
            this.option = x.option
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.HeaderObject = HeaderObject(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
