// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetInstanceMetricDataRequest private constructor(builder: Builder) {
    /**
     * The end time of the time period.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The name of the instance for which you want to get metrics data.
     */
    public val instanceName: kotlin.String? = builder.instanceName
    /**
     * The metric for which you want to return information.
     *
     * Valid instance metric names are listed below, along with the most useful `statistics` to include in your request, and the published `unit` value.
     * + **`BurstCapacityPercentage`** - The percentage of CPU performance available for your instance to burst above its baseline. Your instance continuously accrues and consumes burst capacity. Burst capacity stops accruing when your instance's `BurstCapacityPercentage` reaches 100%. For more information, see [Viewing instance burst capacity in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity).`Statistics`: The most useful statistics are `Maximum` and `Average`.`Unit`: The published unit is `Percent`.
     * + **`BurstCapacityTime`** - The available amount of time for your instance to burst at 100% CPU utilization. Your instance continuously accrues and consumes burst capacity. Burst capacity time stops accruing when your instance's `BurstCapacityPercentage` metric reaches 100%.Burst capacity time is consumed at the full rate only when your instance operates at 100% CPU utilization. For example, if your instance operates at 50% CPU utilization in the burstable zone for a 5-minute period, then it consumes CPU burst capacity minutes at a 50% rate in that period. Your instance consumed 2 minutes and 30 seconds of CPU burst capacity minutes in the 5-minute period. For more information, see [Viewing instance burst capacity in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity).`Statistics`: The most useful statistics are `Maximum` and `Average`.`Unit`: The published unit is `Seconds`.
     * + **`CPUUtilization`** - The percentage of allocated compute units that are currently in use on the instance. This metric identifies the processing power to run the applications on the instance. Tools in your operating system can show a lower percentage than Lightsail when the instance is not allocated a full processor core.`Statistics`: The most useful statistics are `Maximum` and `Average`.`Unit`: The published unit is `Percent`.
     * + **`NetworkIn`** - The number of bytes received on all network interfaces by the instance. This metric identifies the volume of incoming network traffic to the instance. The number reported is the number of bytes received during the period. Because this metric is reported in 5-minute intervals, divide the reported number by 300 to find Bytes/second.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Bytes`.
     * + **`NetworkOut`** - The number of bytes sent out on all network interfaces by the instance. This metric identifies the volume of outgoing network traffic from the instance. The number reported is the number of bytes sent during the period. Because this metric is reported in 5-minute intervals, divide the reported number by 300 to find Bytes/second.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Bytes`.
     * + **`StatusCheckFailed`** - Reports whether the instance passed or failed both the instance status check and the system status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
     * + **`StatusCheckFailed_Instance`** - Reports whether the instance passed or failed the instance status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
     * + **`StatusCheckFailed_System`** - Reports whether the instance passed or failed the system status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
     * + **`MetadataNoToken`** - Reports the number of times that the instance metadata service was successfully accessed without a token. This metric determines if there are any processes accessing instance metadata by using Instance Metadata Service Version 1, which doesn't use a token. If all requests use token-backed sessions, such as Instance Metadata Service Version 2, then the value is 0.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
     */
    public val metricName: aws.sdk.kotlin.services.lightsail.model.InstanceMetricName? = builder.metricName
    /**
     * The granularity, in seconds, of the returned data points.
     *
     * The `StatusCheckFailed`, `StatusCheckFailed_Instance`, and `StatusCheckFailed_System` instance metric data is available in 1-minute (60 seconds) granularity. All other instance metric data is available in 5-minute (300 seconds) granularity.
     */
    public val period: kotlin.Int? = builder.period
    /**
     * The start time of the time period.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The statistic for the metric.
     *
     * The following statistics are available:
     * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
     * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
     * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
     * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
     * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
     */
    public val statistics: List<MetricStatistic>? = builder.statistics
    /**
     * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units to specify with each available metric, see the `metricName` parameter.
     */
    public val unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.GetInstanceMetricDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetInstanceMetricDataRequest(")
        append("endTime=$endTime,")
        append("instanceName=$instanceName,")
        append("metricName=$metricName,")
        append("period=$period,")
        append("startTime=$startTime,")
        append("statistics=$statistics,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (instanceName?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetInstanceMetricDataRequest

        if (endTime != other.endTime) return false
        if (instanceName != other.instanceName) return false
        if (metricName != other.metricName) return false
        if (period != other.period) return false
        if (startTime != other.startTime) return false
        if (statistics != other.statistics) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.GetInstanceMetricDataRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The end time of the time period.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the instance for which you want to get metrics data.
         */
        public var instanceName: kotlin.String? = null
        /**
         * The metric for which you want to return information.
         *
         * Valid instance metric names are listed below, along with the most useful `statistics` to include in your request, and the published `unit` value.
         * + **`BurstCapacityPercentage`** - The percentage of CPU performance available for your instance to burst above its baseline. Your instance continuously accrues and consumes burst capacity. Burst capacity stops accruing when your instance's `BurstCapacityPercentage` reaches 100%. For more information, see [Viewing instance burst capacity in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity).`Statistics`: The most useful statistics are `Maximum` and `Average`.`Unit`: The published unit is `Percent`.
         * + **`BurstCapacityTime`** - The available amount of time for your instance to burst at 100% CPU utilization. Your instance continuously accrues and consumes burst capacity. Burst capacity time stops accruing when your instance's `BurstCapacityPercentage` metric reaches 100%.Burst capacity time is consumed at the full rate only when your instance operates at 100% CPU utilization. For example, if your instance operates at 50% CPU utilization in the burstable zone for a 5-minute period, then it consumes CPU burst capacity minutes at a 50% rate in that period. Your instance consumed 2 minutes and 30 seconds of CPU burst capacity minutes in the 5-minute period. For more information, see [Viewing instance burst capacity in Amazon Lightsail](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-burst-capacity).`Statistics`: The most useful statistics are `Maximum` and `Average`.`Unit`: The published unit is `Seconds`.
         * + **`CPUUtilization`** - The percentage of allocated compute units that are currently in use on the instance. This metric identifies the processing power to run the applications on the instance. Tools in your operating system can show a lower percentage than Lightsail when the instance is not allocated a full processor core.`Statistics`: The most useful statistics are `Maximum` and `Average`.`Unit`: The published unit is `Percent`.
         * + **`NetworkIn`** - The number of bytes received on all network interfaces by the instance. This metric identifies the volume of incoming network traffic to the instance. The number reported is the number of bytes received during the period. Because this metric is reported in 5-minute intervals, divide the reported number by 300 to find Bytes/second.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Bytes`.
         * + **`NetworkOut`** - The number of bytes sent out on all network interfaces by the instance. This metric identifies the volume of outgoing network traffic from the instance. The number reported is the number of bytes sent during the period. Because this metric is reported in 5-minute intervals, divide the reported number by 300 to find Bytes/second.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Bytes`.
         * + **`StatusCheckFailed`** - Reports whether the instance passed or failed both the instance status check and the system status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
         * + **`StatusCheckFailed_Instance`** - Reports whether the instance passed or failed the instance status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
         * + **`StatusCheckFailed_System`** - Reports whether the instance passed or failed the system status check. This metric can be either 0 (passed) or 1 (failed). This metric data is available in 1-minute (60 seconds) granularity.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
         * + **`MetadataNoToken`** - Reports the number of times that the instance metadata service was successfully accessed without a token. This metric determines if there are any processes accessing instance metadata by using Instance Metadata Service Version 1, which doesn't use a token. If all requests use token-backed sessions, such as Instance Metadata Service Version 2, then the value is 0.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `Count`.
         */
        public var metricName: aws.sdk.kotlin.services.lightsail.model.InstanceMetricName? = null
        /**
         * The granularity, in seconds, of the returned data points.
         *
         * The `StatusCheckFailed`, `StatusCheckFailed_Instance`, and `StatusCheckFailed_System` instance metric data is available in 1-minute (60 seconds) granularity. All other instance metric data is available in 5-minute (300 seconds) granularity.
         */
        public var period: kotlin.Int? = null
        /**
         * The start time of the time period.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistic for the metric.
         *
         * The following statistics are available:
         * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
         * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
         * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
         * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
         * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
         */
        public var statistics: List<MetricStatistic>? = null
        /**
         * The unit for the metric data request. Valid units depend on the metric data being requested. For the valid units to specify with each available metric, see the `metricName` parameter.
         */
        public var unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.GetInstanceMetricDataRequest) : this() {
            this.endTime = x.endTime
            this.instanceName = x.instanceName
            this.metricName = x.metricName
            this.period = x.period
            this.startTime = x.startTime
            this.statistics = x.statistics
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.GetInstanceMetricDataRequest = GetInstanceMetricDataRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
