// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetDistributionMetricDataRequest private constructor(builder: Builder) {
    /**
     * The name of the distribution for which to get metric data.
     *
     * Use the `GetDistributions` action to get a list of distribution names that you can specify.
     */
    public val distributionName: kotlin.String? = builder.distributionName
    /**
     * The end of the time interval for which to get metric data.
     *
     * Constraints:
     * + Specified in Coordinated Universal Time (UTC).
     * + Specified in the Unix time format.For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify `1538427600` as the end time.
     *
     * You can convert a human-friendly time to Unix time format using a converter like [Epoch converter](https://www.epochconverter.com/).
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The metric for which you want to return information.
     *
     * Valid distribution metric names are listed below, along with the most useful `statistics` to include in your request, and the published `unit` value.
     * + **`Requests`** - The total number of viewer requests received by your Lightsail distribution, for all HTTP methods, and for both HTTP and HTTPS requests.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `None`.
     * + **`BytesDownloaded`** - The number of bytes downloaded by viewers for GET, HEAD, and OPTIONS requests.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `None`.
     * + **`BytesUploaded `** - The number of bytes uploaded to your origin by your Lightsail distribution, using POST and PUT requests.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `None`.
     * + **`TotalErrorRate`** - The percentage of all viewer requests for which the response's HTTP status code was 4xx or 5xx.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Percent`.
     * + **`4xxErrorRate`** - The percentage of all viewer requests for which the response's HTTP status cod was 4xx. In these cases, the client or client viewer may have made an error. For example, a status code of 404 (Not Found) means that the client requested an object that could not be found.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Percent`.
     * + **`5xxErrorRate`** - The percentage of all viewer requests for which the response's HTTP status code was 5xx. In these cases, the origin server did not satisfy the requests. For example, a status code of 503 (Service Unavailable) means that the origin server is currently unavailable.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Percent`.
     */
    public val metricName: aws.sdk.kotlin.services.lightsail.model.DistributionMetricName? = builder.metricName
    /**
     * The granularity, in seconds, for the metric data points that will be returned.
     */
    public val period: kotlin.Int? = builder.period
    /**
     * The start of the time interval for which to get metric data.
     *
     * Constraints:
     * + Specified in Coordinated Universal Time (UTC).
     * + Specified in the Unix time format.For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify `1538424000` as the start time.
     *
     * You can convert a human-friendly time to Unix time format using a converter like [Epoch converter](https://www.epochconverter.com/).
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The statistic for the metric.
     *
     * The following statistics are available:
     * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
     * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
     * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
     * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
     * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
     */
    public val statistics: List<MetricStatistic>? = builder.statistics
    /**
     * The unit for the metric data request.
     *
     * Valid units depend on the metric data being requested. For the valid units with each available metric, see the `metricName` parameter.
     */
    public val unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.GetDistributionMetricDataRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDistributionMetricDataRequest(")
        append("distributionName=$distributionName,")
        append("endTime=$endTime,")
        append("metricName=$metricName,")
        append("period=$period,")
        append("startTime=$startTime,")
        append("statistics=$statistics,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = distributionName?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (metricName?.hashCode() ?: 0)
        result = 31 * result + (period ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDistributionMetricDataRequest

        if (distributionName != other.distributionName) return false
        if (endTime != other.endTime) return false
        if (metricName != other.metricName) return false
        if (period != other.period) return false
        if (startTime != other.startTime) return false
        if (statistics != other.statistics) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.GetDistributionMetricDataRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the distribution for which to get metric data.
         *
         * Use the `GetDistributions` action to get a list of distribution names that you can specify.
         */
        public var distributionName: kotlin.String? = null
        /**
         * The end of the time interval for which to get metric data.
         *
         * Constraints:
         * + Specified in Coordinated Universal Time (UTC).
         * + Specified in the Unix time format.For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify `1538427600` as the end time.
         *
         * You can convert a human-friendly time to Unix time format using a converter like [Epoch converter](https://www.epochconverter.com/).
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The metric for which you want to return information.
         *
         * Valid distribution metric names are listed below, along with the most useful `statistics` to include in your request, and the published `unit` value.
         * + **`Requests`** - The total number of viewer requests received by your Lightsail distribution, for all HTTP methods, and for both HTTP and HTTPS requests.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `None`.
         * + **`BytesDownloaded`** - The number of bytes downloaded by viewers for GET, HEAD, and OPTIONS requests.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `None`.
         * + **`BytesUploaded `** - The number of bytes uploaded to your origin by your Lightsail distribution, using POST and PUT requests.`Statistics`: The most useful statistic is `Sum`.`Unit`: The published unit is `None`.
         * + **`TotalErrorRate`** - The percentage of all viewer requests for which the response's HTTP status code was 4xx or 5xx.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Percent`.
         * + **`4xxErrorRate`** - The percentage of all viewer requests for which the response's HTTP status cod was 4xx. In these cases, the client or client viewer may have made an error. For example, a status code of 404 (Not Found) means that the client requested an object that could not be found.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Percent`.
         * + **`5xxErrorRate`** - The percentage of all viewer requests for which the response's HTTP status code was 5xx. In these cases, the origin server did not satisfy the requests. For example, a status code of 503 (Service Unavailable) means that the origin server is currently unavailable.`Statistics`: The most useful statistic is `Average`.`Unit`: The published unit is `Percent`.
         */
        public var metricName: aws.sdk.kotlin.services.lightsail.model.DistributionMetricName? = null
        /**
         * The granularity, in seconds, for the metric data points that will be returned.
         */
        public var period: kotlin.Int? = null
        /**
         * The start of the time interval for which to get metric data.
         *
         * Constraints:
         * + Specified in Coordinated Universal Time (UTC).
         * + Specified in the Unix time format.For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify `1538424000` as the start time.
         *
         * You can convert a human-friendly time to Unix time format using a converter like [Epoch converter](https://www.epochconverter.com/).
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The statistic for the metric.
         *
         * The following statistics are available:
         * + `Minimum` - The lowest value observed during the specified period. Use this value to determine low volumes of activity for your application.
         * + `Maximum` - The highest value observed during the specified period. Use this value to determine high volumes of activity for your application.
         * + `Sum` - All values submitted for the matching metric added together. You can use this statistic to determine the total volume of a metric.
         * + `Average` - The value of Sum / SampleCount during the specified period. By comparing this statistic with the Minimum and Maximum values, you can determine the full scope of a metric and how close the average use is to the Minimum and Maximum values. This comparison helps you to know when to increase or decrease your resources.
         * + `SampleCount` - The count, or number, of data points used for the statistical calculation.
         */
        public var statistics: List<MetricStatistic>? = null
        /**
         * The unit for the metric data request.
         *
         * Valid units depend on the metric data being requested. For the valid units with each available metric, see the `metricName` parameter.
         */
        public var unit: aws.sdk.kotlin.services.lightsail.model.MetricUnit? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.GetDistributionMetricDataRequest) : this() {
            this.distributionName = x.distributionName
            this.endTime = x.endTime
            this.metricName = x.metricName
            this.period = x.period
            this.startTime = x.startTime
            this.statistics = x.statistics
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.GetDistributionMetricDataRequest = GetDistributionMetricDataRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
