// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetContainerLogRequest private constructor(builder: Builder) {
    /**
     * The name of the container that is either running or previously ran on the container service for which to return a log.
     */
    public val containerName: kotlin.String? = builder.containerName
    /**
     * The end of the time interval for which to get log data.
     *
     * Constraints:
     * + Specified in Coordinated Universal Time (UTC).
     * + Specified in the Unix time format.For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify `1538427600` as the end time.
     *
     * You can convert a human-friendly time to Unix time format using a converter like [Epoch converter](https://www.epochconverter.com/).
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The pattern to use to filter the returned log events to a specific term.
     *
     * The following are a few examples of filter patterns that you can specify:
     * + To return all log events, specify a filter pattern of `""`.
     * + To exclude log events that contain the `ERROR` term, and return all other log events, specify a filter pattern of `"-ERROR"`.
     * + To return log events that contain the `ERROR` term, specify a filter pattern of `"ERROR"`.
     * + To return log events that contain both the `ERROR` and `Exception` terms, specify a filter pattern of `"ERROR Exception"`.
     * + To return log events that contain the `ERROR`*or* the `Exception` term, specify a filter pattern of `"?ERROR ?Exception"`.
     */
    public val filterPattern: kotlin.String? = builder.filterPattern
    /**
     * The token to advance to the next page of results from your request.
     *
     * To get a page token, perform an initial `GetContainerLog` request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.
     */
    public val pageToken: kotlin.String? = builder.pageToken
    /**
     * The name of the container service for which to get a container log.
     */
    public val serviceName: kotlin.String? = builder.serviceName
    /**
     * The start of the time interval for which to get log data.
     *
     * Constraints:
     * + Specified in Coordinated Universal Time (UTC).
     * + Specified in the Unix time format.For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify `1538424000` as the start time.
     *
     * You can convert a human-friendly time to Unix time format using a converter like [Epoch converter](https://www.epochconverter.com/).
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.GetContainerLogRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetContainerLogRequest(")
        append("containerName=$containerName,")
        append("endTime=$endTime,")
        append("filterPattern=$filterPattern,")
        append("pageToken=$pageToken,")
        append("serviceName=$serviceName,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerName?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (filterPattern?.hashCode() ?: 0)
        result = 31 * result + (pageToken?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetContainerLogRequest

        if (containerName != other.containerName) return false
        if (endTime != other.endTime) return false
        if (filterPattern != other.filterPattern) return false
        if (pageToken != other.pageToken) return false
        if (serviceName != other.serviceName) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.GetContainerLogRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the container that is either running or previously ran on the container service for which to return a log.
         */
        public var containerName: kotlin.String? = null
        /**
         * The end of the time interval for which to get log data.
         *
         * Constraints:
         * + Specified in Coordinated Universal Time (UTC).
         * + Specified in the Unix time format.For example, if you wish to use an end time of October 1, 2018, at 9 PM UTC, specify `1538427600` as the end time.
         *
         * You can convert a human-friendly time to Unix time format using a converter like [Epoch converter](https://www.epochconverter.com/).
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The pattern to use to filter the returned log events to a specific term.
         *
         * The following are a few examples of filter patterns that you can specify:
         * + To return all log events, specify a filter pattern of `""`.
         * + To exclude log events that contain the `ERROR` term, and return all other log events, specify a filter pattern of `"-ERROR"`.
         * + To return log events that contain the `ERROR` term, specify a filter pattern of `"ERROR"`.
         * + To return log events that contain both the `ERROR` and `Exception` terms, specify a filter pattern of `"ERROR Exception"`.
         * + To return log events that contain the `ERROR`*or* the `Exception` term, specify a filter pattern of `"?ERROR ?Exception"`.
         */
        public var filterPattern: kotlin.String? = null
        /**
         * The token to advance to the next page of results from your request.
         *
         * To get a page token, perform an initial `GetContainerLog` request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.
         */
        public var pageToken: kotlin.String? = null
        /**
         * The name of the container service for which to get a container log.
         */
        public var serviceName: kotlin.String? = null
        /**
         * The start of the time interval for which to get log data.
         *
         * Constraints:
         * + Specified in Coordinated Universal Time (UTC).
         * + Specified in the Unix time format.For example, if you wish to use a start time of October 1, 2018, at 8 PM UTC, specify `1538424000` as the start time.
         *
         * You can convert a human-friendly time to Unix time format using a converter like [Epoch converter](https://www.epochconverter.com/).
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.GetContainerLogRequest) : this() {
            this.containerName = x.containerName
            this.endTime = x.endTime
            this.filterPattern = x.filterPattern
            this.pageToken = x.pageToken
            this.serviceName = x.serviceName
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.GetContainerLogRequest = GetContainerLogRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
