// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetCertificatesRequest private constructor(builder: Builder) {
    /**
     * The name for the certificate for which to return information.
     *
     * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the request is made.
     */
    public val certificateName: kotlin.String? = builder.certificateName
    /**
     * The status of the certificates for which to return information.
     *
     * For example, specify `ISSUED` to return only certificates with an `ISSUED` status.
     *
     * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the request is made, regardless of their current status.
     */
    public val certificateStatuses: List<CertificateStatus>? = builder.certificateStatuses
    /**
     * Indicates whether to include detailed information about the certificates in the response.
     *
     * When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain names, and tags.
     */
    public val includeCertificateDetails: kotlin.Boolean? = builder.includeCertificateDetails
    /**
     * The token to advance to the next page of results from your request.
     *
     * To get a page token, perform an initial `GetCertificates` request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.
     */
    public val pageToken: kotlin.String? = builder.pageToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.GetCertificatesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCertificatesRequest(")
        append("certificateName=$certificateName,")
        append("certificateStatuses=$certificateStatuses,")
        append("includeCertificateDetails=$includeCertificateDetails,")
        append("pageToken=$pageToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateName?.hashCode() ?: 0
        result = 31 * result + (certificateStatuses?.hashCode() ?: 0)
        result = 31 * result + (includeCertificateDetails?.hashCode() ?: 0)
        result = 31 * result + (pageToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCertificatesRequest

        if (certificateName != other.certificateName) return false
        if (certificateStatuses != other.certificateStatuses) return false
        if (includeCertificateDetails != other.includeCertificateDetails) return false
        if (pageToken != other.pageToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.GetCertificatesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name for the certificate for which to return information.
         *
         * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the request is made.
         */
        public var certificateName: kotlin.String? = null
        /**
         * The status of the certificates for which to return information.
         *
         * For example, specify `ISSUED` to return only certificates with an `ISSUED` status.
         *
         * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the request is made, regardless of their current status.
         */
        public var certificateStatuses: List<CertificateStatus>? = null
        /**
         * Indicates whether to include detailed information about the certificates in the response.
         *
         * When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain names, and tags.
         */
        public var includeCertificateDetails: kotlin.Boolean? = null
        /**
         * The token to advance to the next page of results from your request.
         *
         * To get a page token, perform an initial `GetCertificates` request. If your results are paginated, the response will return a next page token that you can specify as the page token in a subsequent request.
         */
        public var pageToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.GetCertificatesRequest) : this() {
            this.certificateName = x.certificateName
            this.certificateStatuses = x.certificateStatuses
            this.includeCertificateDetails = x.includeCertificateDetails
            this.pageToken = x.pageToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.GetCertificatesRequest = GetCertificatesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
