// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the source of an export snapshot record.
 */
public class ExportSnapshotRecordSourceInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the source instance or disk snapshot.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date when the source instance or disk snapshot was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A list of objects describing a disk snapshot.
     */
    public val diskSnapshotInfo: aws.sdk.kotlin.services.lightsail.model.DiskSnapshotInfo? = builder.diskSnapshotInfo
    /**
     * The Amazon Resource Name (ARN) of the snapshot's source instance or disk.
     */
    public val fromResourceArn: kotlin.String? = builder.fromResourceArn
    /**
     * The name of the snapshot's source instance or disk.
     */
    public val fromResourceName: kotlin.String? = builder.fromResourceName
    /**
     * A list of objects describing an instance snapshot.
     */
    public val instanceSnapshotInfo: aws.sdk.kotlin.services.lightsail.model.InstanceSnapshotInfo? = builder.instanceSnapshotInfo
    /**
     * The name of the source instance or disk snapshot.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Lightsail resource type (`InstanceSnapshot` or `DiskSnapshot`).
     */
    public val resourceType: aws.sdk.kotlin.services.lightsail.model.ExportSnapshotRecordSourceType? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.ExportSnapshotRecordSourceInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportSnapshotRecordSourceInfo(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("diskSnapshotInfo=$diskSnapshotInfo,")
        append("fromResourceArn=$fromResourceArn,")
        append("fromResourceName=$fromResourceName,")
        append("instanceSnapshotInfo=$instanceSnapshotInfo,")
        append("name=$name,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (diskSnapshotInfo?.hashCode() ?: 0)
        result = 31 * result + (fromResourceArn?.hashCode() ?: 0)
        result = 31 * result + (fromResourceName?.hashCode() ?: 0)
        result = 31 * result + (instanceSnapshotInfo?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportSnapshotRecordSourceInfo

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (diskSnapshotInfo != other.diskSnapshotInfo) return false
        if (fromResourceArn != other.fromResourceArn) return false
        if (fromResourceName != other.fromResourceName) return false
        if (instanceSnapshotInfo != other.instanceSnapshotInfo) return false
        if (name != other.name) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.ExportSnapshotRecordSourceInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the source instance or disk snapshot.
         */
        public var arn: kotlin.String? = null
        /**
         * The date when the source instance or disk snapshot was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of objects describing a disk snapshot.
         */
        public var diskSnapshotInfo: aws.sdk.kotlin.services.lightsail.model.DiskSnapshotInfo? = null
        /**
         * The Amazon Resource Name (ARN) of the snapshot's source instance or disk.
         */
        public var fromResourceArn: kotlin.String? = null
        /**
         * The name of the snapshot's source instance or disk.
         */
        public var fromResourceName: kotlin.String? = null
        /**
         * A list of objects describing an instance snapshot.
         */
        public var instanceSnapshotInfo: aws.sdk.kotlin.services.lightsail.model.InstanceSnapshotInfo? = null
        /**
         * The name of the source instance or disk snapshot.
         */
        public var name: kotlin.String? = null
        /**
         * The Lightsail resource type (`InstanceSnapshot` or `DiskSnapshot`).
         */
        public var resourceType: aws.sdk.kotlin.services.lightsail.model.ExportSnapshotRecordSourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.ExportSnapshotRecordSourceInfo) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.diskSnapshotInfo = x.diskSnapshotInfo
            this.fromResourceArn = x.fromResourceArn
            this.fromResourceName = x.fromResourceName
            this.instanceSnapshotInfo = x.instanceSnapshotInfo
            this.name = x.name
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.ExportSnapshotRecordSourceInfo = ExportSnapshotRecordSourceInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.DiskSnapshotInfo] inside the given [block]
         */
        public fun diskSnapshotInfo(block: aws.sdk.kotlin.services.lightsail.model.DiskSnapshotInfo.Builder.() -> kotlin.Unit) {
            this.diskSnapshotInfo = aws.sdk.kotlin.services.lightsail.model.DiskSnapshotInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.lightsail.model.InstanceSnapshotInfo] inside the given [block]
         */
        public fun instanceSnapshotInfo(block: aws.sdk.kotlin.services.lightsail.model.InstanceSnapshotInfo.Builder.() -> kotlin.Unit) {
            this.instanceSnapshotInfo = aws.sdk.kotlin.services.lightsail.model.InstanceSnapshotInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
