// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a domain recordset entry.
 */
public class DomainEntry private constructor(builder: Builder) {
    /**
     * The ID of the domain recordset entry.
     */
    public val id: kotlin.String? = builder.id
    /**
     * When `true`, specifies whether the domain entry is an alias used by the Lightsail load balancer, Lightsail container service, Lightsail content delivery network (CDN) distribution, or another Amazon Web Services resource. You can include an alias (A type) record in your request, which points to the DNS name of a load balancer, container service, CDN distribution, or other Amazon Web Services resource and routes traffic to that resource.
     */
    public val isAlias: kotlin.Boolean? = builder.isAlias
    /**
     * The name of the domain.
     */
    public val name: kotlin.String? = builder.name
    /**
     * (Discontinued) The options for the domain entry.
     *
     * In releases prior to November 29, 2017, this parameter was not included in the API response. It is now discontinued.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val options: Map<String, String>? = builder.options
    /**
     * The target IP address (`192.0.2.0`), or AWS name server (`ns-111.awsdns-22.com.`).
     *
     * For Lightsail load balancers, the value looks like `ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com`. For Lightsail distributions, the value looks like `exampled1182ne.cloudfront.net`. For Lightsail container services, the value looks like `container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com`. Be sure to also set `isAlias` to `true` when setting up an A record for a Lightsail load balancer, distribution, or container service.
     */
    public val target: kotlin.String? = builder.target
    /**
     * The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
     *
     * The following domain entry types can be used:
     * + `A`
     * + `AAAA`
     * + `CNAME`
     * + `MX`
     * + `NS`
     * + `SOA`
     * + `SRV`
     * + `TXT`
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.DomainEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainEntry(")
        append("id=$id,")
        append("isAlias=$isAlias,")
        append("name=$name,")
        append("options=$options,")
        append("target=$target,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (isAlias?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainEntry

        if (id != other.id) return false
        if (isAlias != other.isAlias) return false
        if (name != other.name) return false
        if (options != other.options) return false
        if (target != other.target) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.DomainEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the domain recordset entry.
         */
        public var id: kotlin.String? = null
        /**
         * When `true`, specifies whether the domain entry is an alias used by the Lightsail load balancer, Lightsail container service, Lightsail content delivery network (CDN) distribution, or another Amazon Web Services resource. You can include an alias (A type) record in your request, which points to the DNS name of a load balancer, container service, CDN distribution, or other Amazon Web Services resource and routes traffic to that resource.
         */
        public var isAlias: kotlin.Boolean? = null
        /**
         * The name of the domain.
         */
        public var name: kotlin.String? = null
        /**
         * (Discontinued) The options for the domain entry.
         *
         * In releases prior to November 29, 2017, this parameter was not included in the API response. It is now discontinued.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var options: Map<String, String>? = null
        /**
         * The target IP address (`192.0.2.0`), or AWS name server (`ns-111.awsdns-22.com.`).
         *
         * For Lightsail load balancers, the value looks like `ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com`. For Lightsail distributions, the value looks like `exampled1182ne.cloudfront.net`. For Lightsail container services, the value looks like `container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com`. Be sure to also set `isAlias` to `true` when setting up an A record for a Lightsail load balancer, distribution, or container service.
         */
        public var target: kotlin.String? = null
        /**
         * The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA), canonical name (CNAME), mail exchanger (MX), name server (NS), start of authority (SOA), service locator (SRV), or text (TXT).
         *
         * The following domain entry types can be used:
         * + `A`
         * + `AAAA`
         * + `CNAME`
         * + `MX`
         * + `NS`
         * + `SOA`
         * + `SRV`
         * + `TXT`
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.DomainEntry) : this() {
            this.id = x.id
            this.isAlias = x.isAlias
            this.name = x.name
            this.options = x.options
            this.target = x.target
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.DomainEntry = DomainEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
