// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateInstancesFromSnapshotRequest private constructor(builder: Builder) {
    /**
     * An array of objects representing the add-ons to enable for the new instance.
     */
    public val addOns: List<AddOnRequest>? = builder.addOns
    /**
     * An object containing information about one or more disk mappings.
     */
    public val attachedDiskMapping: Map<String, List<DiskMap>>? = builder.attachedDiskMapping
    /**
     * The Availability Zone where you want to create your instances. Use the following formatting: `us-east-2a` (case sensitive). You can get a list of Availability Zones by using the [get regions](http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html) operation. Be sure to add the `include Availability Zones` parameter to your request.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The bundle of specification information for your virtual private server (or *instance*), including the pricing plan (`micro_x_x`).
     */
    public val bundleId: kotlin.String? = builder.bundleId
    /**
     * The names for your new instances.
     */
    public val instanceNames: List<String>? = builder.instanceNames
    /**
     * The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots operation to return information about your existing snapshots.
     *
     * Constraint:
     * + This parameter cannot be defined together with the `source instance name` parameter. The `instance snapshot name` and `source instance name` parameters are mutually exclusive.
     */
    public val instanceSnapshotName: kotlin.String? = builder.instanceSnapshotName
    /**
     * The IP address type for the instance.
     *
     * The possible values are `ipv4` for IPv4 only, `ipv6` for IPv6 only, and `dualstack` for IPv4 and IPv6.
     *
     * The default value is `dualstack`.
     */
    public val ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = builder.ipAddressType
    /**
     * The name for your key pair.
     */
    public val keyPairName: kotlin.String? = builder.keyPairName
    /**
     * The date of the automatic snapshot to use for the new instance. Use the `get auto snapshots` operation to identify the dates of the available automatic snapshots.
     *
     * Constraints:
     * + Must be specified in `YYYY-MM-DD` format.
     * + This parameter cannot be defined together with the `use latest restorable auto snapshot` parameter. The `restore date` and `use latest restorable auto snapshot` parameters are mutually exclusive.
     * + Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public val restoreDate: kotlin.String? = builder.restoreDate
    /**
     * The name of the source instance from which the source automatic snapshot was created.
     *
     * Constraints:
     * + This parameter cannot be defined together with the `instance snapshot name` parameter. The `source instance name` and `instance snapshot name` parameters are mutually exclusive.
     * + Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public val sourceInstanceName: kotlin.String? = builder.sourceInstanceName
    /**
     * The tag keys and optional values to add to the resource during create.
     *
     * Use the `TagResource` action to tag a resource after it's created.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A Boolean value to indicate whether to use the latest available automatic snapshot.
     *
     * Constraints:
     * + This parameter cannot be defined together with the `restore date` parameter. The `use latest restorable auto snapshot` and `restore date` parameters are mutually exclusive.
     * + Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public val useLatestRestorableAutoSnapshot: kotlin.Boolean? = builder.useLatestRestorableAutoSnapshot
    /**
     * You can create a launch script that configures a server with additional user data. For example, `apt-get -y update`.
     *
     * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use `yum`, Debian and Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image).
     */
    public val userData: kotlin.String? = builder.userData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateInstancesFromSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateInstancesFromSnapshotRequest(")
        append("addOns=$addOns,")
        append("attachedDiskMapping=$attachedDiskMapping,")
        append("availabilityZone=$availabilityZone,")
        append("bundleId=$bundleId,")
        append("instanceNames=$instanceNames,")
        append("instanceSnapshotName=$instanceSnapshotName,")
        append("ipAddressType=$ipAddressType,")
        append("keyPairName=$keyPairName,")
        append("restoreDate=$restoreDate,")
        append("sourceInstanceName=$sourceInstanceName,")
        append("tags=$tags,")
        append("useLatestRestorableAutoSnapshot=$useLatestRestorableAutoSnapshot,")
        append("userData=$userData")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addOns?.hashCode() ?: 0
        result = 31 * result + (attachedDiskMapping?.hashCode() ?: 0)
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (bundleId?.hashCode() ?: 0)
        result = 31 * result + (instanceNames?.hashCode() ?: 0)
        result = 31 * result + (instanceSnapshotName?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (keyPairName?.hashCode() ?: 0)
        result = 31 * result + (restoreDate?.hashCode() ?: 0)
        result = 31 * result + (sourceInstanceName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableAutoSnapshot?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateInstancesFromSnapshotRequest

        if (addOns != other.addOns) return false
        if (attachedDiskMapping != other.attachedDiskMapping) return false
        if (availabilityZone != other.availabilityZone) return false
        if (bundleId != other.bundleId) return false
        if (instanceNames != other.instanceNames) return false
        if (instanceSnapshotName != other.instanceSnapshotName) return false
        if (ipAddressType != other.ipAddressType) return false
        if (keyPairName != other.keyPairName) return false
        if (restoreDate != other.restoreDate) return false
        if (sourceInstanceName != other.sourceInstanceName) return false
        if (tags != other.tags) return false
        if (useLatestRestorableAutoSnapshot != other.useLatestRestorableAutoSnapshot) return false
        if (userData != other.userData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateInstancesFromSnapshotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of objects representing the add-ons to enable for the new instance.
         */
        public var addOns: List<AddOnRequest>? = null
        /**
         * An object containing information about one or more disk mappings.
         */
        public var attachedDiskMapping: Map<String, List<DiskMap>>? = null
        /**
         * The Availability Zone where you want to create your instances. Use the following formatting: `us-east-2a` (case sensitive). You can get a list of Availability Zones by using the [get regions](http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html) operation. Be sure to add the `include Availability Zones` parameter to your request.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The bundle of specification information for your virtual private server (or *instance*), including the pricing plan (`micro_x_x`).
         */
        public var bundleId: kotlin.String? = null
        /**
         * The names for your new instances.
         */
        public var instanceNames: List<String>? = null
        /**
         * The name of the instance snapshot on which you are basing your new instances. Use the get instance snapshots operation to return information about your existing snapshots.
         *
         * Constraint:
         * + This parameter cannot be defined together with the `source instance name` parameter. The `instance snapshot name` and `source instance name` parameters are mutually exclusive.
         */
        public var instanceSnapshotName: kotlin.String? = null
        /**
         * The IP address type for the instance.
         *
         * The possible values are `ipv4` for IPv4 only, `ipv6` for IPv6 only, and `dualstack` for IPv4 and IPv6.
         *
         * The default value is `dualstack`.
         */
        public var ipAddressType: aws.sdk.kotlin.services.lightsail.model.IpAddressType? = null
        /**
         * The name for your key pair.
         */
        public var keyPairName: kotlin.String? = null
        /**
         * The date of the automatic snapshot to use for the new instance. Use the `get auto snapshots` operation to identify the dates of the available automatic snapshots.
         *
         * Constraints:
         * + Must be specified in `YYYY-MM-DD` format.
         * + This parameter cannot be defined together with the `use latest restorable auto snapshot` parameter. The `restore date` and `use latest restorable auto snapshot` parameters are mutually exclusive.
         * + Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
         */
        public var restoreDate: kotlin.String? = null
        /**
         * The name of the source instance from which the source automatic snapshot was created.
         *
         * Constraints:
         * + This parameter cannot be defined together with the `instance snapshot name` parameter. The `source instance name` and `instance snapshot name` parameters are mutually exclusive.
         * + Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
         */
        public var sourceInstanceName: kotlin.String? = null
        /**
         * The tag keys and optional values to add to the resource during create.
         *
         * Use the `TagResource` action to tag a resource after it's created.
         */
        public var tags: List<Tag>? = null
        /**
         * A Boolean value to indicate whether to use the latest available automatic snapshot.
         *
         * Constraints:
         * + This parameter cannot be defined together with the `restore date` parameter. The `use latest restorable auto snapshot` and `restore date` parameters are mutually exclusive.
         * + Define this parameter only when creating a new instance from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
         */
        public var useLatestRestorableAutoSnapshot: kotlin.Boolean? = null
        /**
         * You can create a launch script that configures a server with additional user data. For example, `apt-get -y update`.
         *
         * Depending on the machine image you choose, the command to get software on your instance varies. Amazon Linux and CentOS use `yum`, Debian and Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/compare-options-choose-lightsail-instance-image).
         */
        public var userData: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateInstancesFromSnapshotRequest) : this() {
            this.addOns = x.addOns
            this.attachedDiskMapping = x.attachedDiskMapping
            this.availabilityZone = x.availabilityZone
            this.bundleId = x.bundleId
            this.instanceNames = x.instanceNames
            this.instanceSnapshotName = x.instanceSnapshotName
            this.ipAddressType = x.ipAddressType
            this.keyPairName = x.keyPairName
            this.restoreDate = x.restoreDate
            this.sourceInstanceName = x.sourceInstanceName
            this.tags = x.tags
            this.useLatestRestorableAutoSnapshot = x.useLatestRestorableAutoSnapshot
            this.userData = x.userData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateInstancesFromSnapshotRequest = CreateInstancesFromSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
