// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.lightsail.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateDiskFromSnapshotRequest private constructor(builder: Builder) {
    /**
     * An array of objects that represent the add-ons to enable for the new disk.
     */
    public val addOns: List<AddOnRequest>? = builder.addOns
    /**
     * The Availability Zone where you want to create the disk (`us-east-2a`). Choose the same Availability Zone as the Lightsail instance where you want to create the disk.
     *
     * Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The unique Lightsail disk name (`my-disk`).
     */
    public val diskName: kotlin.String? = builder.diskName
    /**
     * The name of the disk snapshot (`my-snapshot`) from which to create the new storage disk.
     *
     * Constraint:
     * + This parameter cannot be defined together with the `source disk name` parameter. The `disk snapshot name` and `source disk name` parameters are mutually exclusive.
     */
    public val diskSnapshotName: kotlin.String? = builder.diskSnapshotName
    /**
     * The date of the automatic snapshot to use for the new disk. Use the `get auto snapshots` operation to identify the dates of the available automatic snapshots.
     *
     * Constraints:
     * + Must be specified in `YYYY-MM-DD` format.
     * + This parameter cannot be defined together with the `use latest restorable auto snapshot` parameter. The `restore date` and `use latest restorable auto snapshot` parameters are mutually exclusive.
     * + Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public val restoreDate: kotlin.String? = builder.restoreDate
    /**
     * The size of the disk in GB (`32`).
     */
    public val sizeInGb: kotlin.Int? = builder.sizeInGb
    /**
     * The name of the source disk from which the source automatic snapshot was created.
     *
     * Constraints:
     * + This parameter cannot be defined together with the `disk snapshot name` parameter. The `source disk name` and `disk snapshot name` parameters are mutually exclusive.
     * + Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public val sourceDiskName: kotlin.String? = builder.sourceDiskName
    /**
     * The tag keys and optional values to add to the resource during create.
     *
     * Use the `TagResource` action to tag a resource after it's created.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * A Boolean value to indicate whether to use the latest available automatic snapshot.
     *
     * Constraints:
     * + This parameter cannot be defined together with the `restore date` parameter. The `use latest restorable auto snapshot` and `restore date` parameters are mutually exclusive.
     * + Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
     */
    public val useLatestRestorableAutoSnapshot: kotlin.Boolean? = builder.useLatestRestorableAutoSnapshot

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.lightsail.model.CreateDiskFromSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDiskFromSnapshotRequest(")
        append("addOns=$addOns,")
        append("availabilityZone=$availabilityZone,")
        append("diskName=$diskName,")
        append("diskSnapshotName=$diskSnapshotName,")
        append("restoreDate=$restoreDate,")
        append("sizeInGb=$sizeInGb,")
        append("sourceDiskName=$sourceDiskName,")
        append("tags=$tags,")
        append("useLatestRestorableAutoSnapshot=$useLatestRestorableAutoSnapshot")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addOns?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (diskName?.hashCode() ?: 0)
        result = 31 * result + (diskSnapshotName?.hashCode() ?: 0)
        result = 31 * result + (restoreDate?.hashCode() ?: 0)
        result = 31 * result + (sizeInGb ?: 0)
        result = 31 * result + (sourceDiskName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (useLatestRestorableAutoSnapshot?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDiskFromSnapshotRequest

        if (addOns != other.addOns) return false
        if (availabilityZone != other.availabilityZone) return false
        if (diskName != other.diskName) return false
        if (diskSnapshotName != other.diskSnapshotName) return false
        if (restoreDate != other.restoreDate) return false
        if (sizeInGb != other.sizeInGb) return false
        if (sourceDiskName != other.sourceDiskName) return false
        if (tags != other.tags) return false
        if (useLatestRestorableAutoSnapshot != other.useLatestRestorableAutoSnapshot) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.lightsail.model.CreateDiskFromSnapshotRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of objects that represent the add-ons to enable for the new disk.
         */
        public var addOns: List<AddOnRequest>? = null
        /**
         * The Availability Zone where you want to create the disk (`us-east-2a`). Choose the same Availability Zone as the Lightsail instance where you want to create the disk.
         *
         * Use the GetRegions operation to list the Availability Zones where Lightsail is currently available.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The unique Lightsail disk name (`my-disk`).
         */
        public var diskName: kotlin.String? = null
        /**
         * The name of the disk snapshot (`my-snapshot`) from which to create the new storage disk.
         *
         * Constraint:
         * + This parameter cannot be defined together with the `source disk name` parameter. The `disk snapshot name` and `source disk name` parameters are mutually exclusive.
         */
        public var diskSnapshotName: kotlin.String? = null
        /**
         * The date of the automatic snapshot to use for the new disk. Use the `get auto snapshots` operation to identify the dates of the available automatic snapshots.
         *
         * Constraints:
         * + Must be specified in `YYYY-MM-DD` format.
         * + This parameter cannot be defined together with the `use latest restorable auto snapshot` parameter. The `restore date` and `use latest restorable auto snapshot` parameters are mutually exclusive.
         * + Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
         */
        public var restoreDate: kotlin.String? = null
        /**
         * The size of the disk in GB (`32`).
         */
        public var sizeInGb: kotlin.Int? = null
        /**
         * The name of the source disk from which the source automatic snapshot was created.
         *
         * Constraints:
         * + This parameter cannot be defined together with the `disk snapshot name` parameter. The `source disk name` and `disk snapshot name` parameters are mutually exclusive.
         * + Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
         */
        public var sourceDiskName: kotlin.String? = null
        /**
         * The tag keys and optional values to add to the resource during create.
         *
         * Use the `TagResource` action to tag a resource after it's created.
         */
        public var tags: List<Tag>? = null
        /**
         * A Boolean value to indicate whether to use the latest available automatic snapshot.
         *
         * Constraints:
         * + This parameter cannot be defined together with the `restore date` parameter. The `use latest restorable auto snapshot` and `restore date` parameters are mutually exclusive.
         * + Define this parameter only when creating a new disk from an automatic snapshot. For more information, see the [Amazon Lightsail Developer Guide](https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configuring-automatic-snapshots).
         */
        public var useLatestRestorableAutoSnapshot: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.lightsail.model.CreateDiskFromSnapshotRequest) : this() {
            this.addOns = x.addOns
            this.availabilityZone = x.availabilityZone
            this.diskName = x.diskName
            this.diskSnapshotName = x.diskSnapshotName
            this.restoreDate = x.restoreDate
            this.sizeInGb = x.sizeInGb
            this.sourceDiskName = x.sourceDiskName
            this.tags = x.tags
            this.useLatestRestorableAutoSnapshot = x.useLatestRestorableAutoSnapshot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.lightsail.model.CreateDiskFromSnapshotRequest = CreateDiskFromSnapshotRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
